<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = '广告位';
$this->params['breadcrumbs'][] = ['label' => '广告管理', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation"><a href="<?= Yii::$app->urlManager->createUrl('/ad');?>">广告列表</a></li>
  <li role="presentation" class="active"><a>广告位</a></li>
</ul>
<?php Pjax::begin(); ?>    
<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => "{items}\n{pager}" ,
        'columns' => [
            'name',
            'alias',
            'max',
            [
                'attribute'=>'type',
                'format'=>'raw',
                'value'=> function($data){
                    return $data->type?'<font color="#FF9900"><b>图片</b></font>':'<font color="#9999FF"><b>文字</b></font>';
                } 
            ],
            [
                'header' => "操作",
                'class' => 'yii\grid\ActionColumn',
                'template'=> '{update} {delete}',
                'headerOptions' => ['width' => '140'],
                'buttons' => [
                    'update' => function ($url, $model, $key){
                          return Html::a('修改', ['update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                    },
                    'delete' => function ($url, $model, $key) {
                            return Html::a("删除", ["delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                    }
                ]
            ],
        ],
    ]); ?>
<?php Pjax::end(); ?>
<?= Html::a('添加', ['create'], ['class' => 'btn btn-success']) ?>
