<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\models\AdCategory;
use yii\widgets\DatePicker;
use common\components\CHelper;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="ad-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal','enctype'=>'multipart/form-data'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'categoryid')->dropdownList(AdCategory::getCache()) ?>

    <?= $form->field($model, 'title',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?php
        if($model->img){
    ?>
    <div class="form-group">
        <label class="col-sm-2 control-label">已上传广告图</label>
        <div class="col-sm-6">
            <img src="<?php echo CHelper::attach($model->img,'ad');?>" class="img-thumbnail" width="200">
        </div>
    </div>
    <?php }?>
    <?= $form->field($model, 'img')->fileInput() ?>
    <?= $form->field($model, 'url',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'explain')->textArea(['maxlength' => true]) ?>
    
    <?= $form->field($model, 'starttime')->widget(
        DatePicker::className(), [
        // inline too, not bad
        'inline' => true, 
        'language'=>'zh-CN',
        // modify template for custom rendering
        'template' => '<div class="well well-sm" style="background-color: #fff; width:250px">{input}</div>',
        'clientOptions' => [
        'autoclose' => true,
        'format' => 'yyyy-mm-dd',
        'startDate'=>date('Y-m-d')
        ]
    ]);?>
    <?= $form->field($model, 'deadline')->widget(
        DatePicker::className(), [
        // inline too, not bad
        'inline' => true, 
        'language'=>'zh-CN',
        // modify template for custom rendering
        'template' => '<div class="well well-sm" style="background-color: #fff; width:250px">{input}</div>',
        'clientOptions' => [
        'autoclose' => true,
        'format' => 'yyyy-mm-dd',
        'startDate'=>date('Y-m-d',strtotime("+1day")),
        ]
    ]);?>
    

    <?= $form->field($model, 'ordid')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'display')->dropdownList(['1'=>'显示','0'=>'隐藏']) ?>
    <?= $form->field($model, 'note')->textArea(['maxlength' => true]) ?>
    
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('ad/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
