<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\models\ArticleCategory;
use common\components\CHelper;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="article-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal','enctype'=>'multipart/form-data'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'cid')->dropdownList(ArticleCategory::getCache()) ?>

    <?= $form->field($model, 'title',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?php
        if($model->thumb){
    ?>
    <div class="form-group">
        <label class="col-sm-2 control-label">已上传缩略图</label>
        <div class="col-sm-6">
            <img src="<?php echo CHelper::attach($model->thumb,'article/thumb');?>" class="img-thumbnail" width="200">
        </div>
    </div>
    <?php }?>
    <?= $form->field($model, 'thumb')->fileInput() ?>

    <?= $form->field($model, 'content')->widget('common\widgets\ueditor\Ueditor',[
        'options'=>[
            'initialFrameWidth' => 800,
            'initialFrameHeight' => 300,
        ]
    ]) ?>
    <?= $form->field($model, 'click',['template'=>"{label}\n<div class=\"col-sm-1\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'url',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'display')->dropdownList(['1'=>'显示','0'=>'隐藏']) ?>
    
    <?= $form->field($model, 'seo_title',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>
    <?= $form->field($model, 'seo_keywords',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textInput(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>
    <?= $form->field($model, 'seo_description',['template'=>"{label}\n<div class=\"col-sm-6\">{input}</div>{error}"])->textArea(['maxlength' => true,'placeholder'=>'如留空系统将自动截取文章内容填充']) ?>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '发布' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('article/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
