<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->params['breadcrumbs'][] = ['label' => '数据备份'];
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>数据备份</a></li>
  <li role="presentation"><a href="<?= Yii::$app->urlManager->createUrl('database/restore');?>">数据还原</a></li>
</ul>
<?php $form = ActiveForm::begin([
    'options'=>['id'=>'form'],
    'action'=>Yii::$app->urlManager->createUrl(['database/backup']),
    'method'=>'get',
]); ?>
<table class="table table-bordered">
    <tr>
        <td><input type="checkbox" id="checkAll" checked></td>
        <th>表名称</th>
        <th>表引擎</th>
        <th>字符集</th>
        <th>行数</th>
        <th>数据大小</th>
        <th>碎片大小</th>
        <th>最后修改时间</th>
        <th>操作</th>
    </tr>
    <?php foreach($list as $key=>$value){?>
    <tr>
        <td><input type="checkbox" name="tables[]" value="<?php echo $value['name'];?>" checked></td>
        <td><?php echo $value['name'];?></td>
        <td><?php echo $value['engine'];?></td>
        <td><?php echo $value['collation'];?></td>
        <td><?php echo $value['rows'];?></td>
        <td><?php echo $value['data_length'];?></td>
        <td><?php echo $value['data_free'];?></td>
        <td><?php echo $value['update_time']?$value['update_time']:'-';?></td>
        <td>
            <a class="btn btn-xs btn-info" href="<?php echo Yii::$app->urlManager->createUrl(['database/backup','tables[]'=>$value['name']]);?>">备份</a>
            <a class="btn btn-xs btn-danger" href="<?php echo Yii::$app->urlManager->createUrl(['database/optimize','tables[]'=>$value['name']]);?>">优化</a>
        </td>
    </tr>
    <?php }?>
</table>
<?= Html::submitButton('备份', ['class' => 'btn btn-primary']) ?>
&nbsp;
<?= Html::button('优化', ['class' => 'btn btn-warning','id'=>'J_optimize']) ?>
<?php ActiveForm::end(); ?>
<?php
    $this->registerJs('
        $("#checkAll").click(function() {
            $("input[name=\'tables[]\']").prop("checked", this.checked);
        });
          
        $("input[name=\'tables[]\']").click(function() {
            var $subs = $("input[name=\'tables[]\']");
            $("#checkAll").prop("checked" , $subs.length == $subs.filter(":checked").length ? true :false);
        });
        $("#J_optimize").click(function(){
            $("#form").append("<input type=\'hidden\' name=\'r\' value=\'database/optimize\'>");
            $("#form").submit();
        });
    ');
?>