<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\components\CHelper;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="link-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal','enctype'=>'multipart/form-data'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-4\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'link_name',['template'=>"{label}\n<div class=\"col-sm-3\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'type',['template'=>"{label}\n<div class=\"col-sm-2\">{input}</div>{error}"])->dropdownList(['0'=>'文字','1'=>'图片']) ?>
    <?php
        if($model->link_logo){
    ?>
    <div class="form-group">
        <label class="col-sm-2 control-label">已上传logo</label>
        <div class="col-sm-6">
            <img src="<?php echo CHelper::attach($model->link_logo,'link');?>" class="img-thumbnail" width="200">
        </div>
    </div>
    <?php }?>
    <?= $form->field($model, 'link_logo')->fileInput() ?>

    <?= $form->field($model, 'link_url')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'ordid',['template'=>"{label}\n<div class=\"col-sm-1\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'notes')->textArea() ?>

    <?= $form->field($model, 'display',['template'=>"{label}\n<div class=\"col-sm-2\">{input}</div>{error}"])->dropdownList(['1'=>'显示','0'=>'隐藏']) ?>
    
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('link/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
