<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 
use common\models\AdminRole;

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Article */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal','enctype'=>'multipart/form-data'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>
    <?php if($model->isNewRecord){?>
    <?= $form->field($model, 'username',['template'=>"{label}\n<div class=\"col-sm-2\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?php }else{?>
    <div class="form-group">
        <label class="col-sm-2 control-label">用户名</label>
        <div class="col-sm-10">
          <p class="form-control-static"><?= $model->username;?></p>
        </div>
      </div>
    <?php }?>
    <?= $form->field($model, 'nickname',['template'=>"{label}\n<div class=\"col-sm-2\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'password',['template'=>"{label}\n<div class=\"col-sm-3\">{input}</div>{error}"])->passwordInput(['maxlength' => true]); ?>

    <?= $form->field($model, 'status')->dropdownList(['1'=>'可用','0'=>'停用']) ?>
    <?php if($model->super==1){?>
    <div class="form-group">
        <label class="col-sm-2 control-label">角色</label>
        <div class="col-sm-6">
            <p class="form-control-static">超级管理员</p>
        </div>
    </div>
    <?php }else{?>
    <?= $form->field($model, 'role')->dropdownList(AdminRole::getall()) ?>
    <?php }?>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('manager/index').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
