<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = '管理员';
$this->params['breadcrumbs'][] = ['label' => '管理员', 'url' => ['manager']];
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>管理员列表</a></li>
  <li role="presentation"><a href="<?php echo Yii::$app->urlManager->createUrl(['manager/role']);?>">角色权限</a></li>
</ul>
<?php Pjax::begin(); ?>    
<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => "{items}\n{pager}" ,
        'columns' => [
            'username',
            [
                'attribute'=>'status',
                'format'=>'raw',
                'value'=> function($data){
                    switch ($data->status) {
                        case '1';
                            return '<font color="green"><b>正常</b></font>';
                            break;
                        default:
                            return '<font color="red"><b>停用</b></font>';
                            break;
                    }
                } 
            ],
            [
                'attribute'=>'last_logintime',
                'value'=> function($data){
                    if($data->last_logintime==0){
                        return '从未登录';
                    }else{
                        return date('Y-m-d H:i',$data->last_logintime);
                    }
                } 
            ],
            [
                'header' => "操作",
                'class' => 'yii\grid\ActionColumn',
                'template'=> '{view} {update} {delete}',
                'headerOptions' => ['width' => '140'],
                'buttons' => [
                    'view' => function ($url, $model, $key) {
                        if($model->status==1){
                            $tag_a = Html::a('停用',['manager/set-status', 'id'=>$model->id,'status'=>0], ['class' => "btn btn-xs btn-warning", 'title' => '停用']);
                        }else{
                            $tag_a = Html::a('启用',['manager/set-status', 'id'=>$model->id,'status'=>1], ['class' => "btn btn-xs btn-success", 'title' => '启用']);
                        }
                        return $tag_a;
                    },
                    'update' => function ($url, $model, $key){
                          return Html::a('修改', ['manager/update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                    },
                    'delete' => function ($url, $model, $key) {
                            return Html::a("删除", ["manager/delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                    }
                ]
            ],
        ],
    ]); ?>
<?php Pjax::end(); ?>
<?= Html::a('添加管理员', ['create'], ['class' => 'btn btn-success']) ?>
