<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\assets\AppAsset; 

$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 

/* @var $this yii\web\View */
/* @var $model common\models\Product */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="product-form">

    <?php $form = ActiveForm::begin([
        'options'=>['class'=>'form-horizontal'],
        'fieldConfig' => [  
            'template' => "{label}\n<div class=\"col-sm-2\">{input}</div>{error}",   
            'labelOptions'=>['class'=>'col-sm-2 control-label'],
        ],
    ]); ?>

    <?php if($model->super){?>
    <div class="form-group">
        <label class="col-sm-2 control-label">角色名称</label>
        <div class="col-sm-6">
            <p class="form-control-static"><?php echo $model->name;?></p>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">角色权限</label>
        <div class="col-sm-6">
            <p class="form-control-static"><font color="green">超级管理员拥有所有权限，无需设置</font></p>
        </div>
    </div>
    <?php }else{?>
    <?= $form->field($model, 'name',['template'=>"{label}\n<div class=\"col-sm-3\">{input}</div>{error}"])->textInput(['maxlength' => true]) ?>
    <div class="form-group">
        <label class="col-sm-2 control-label">角色权限</label>
        <div class="col-sm-6">
            <table class="table table-bordered">
              <colgroup>
                <col class="col-xs-1">
                <col class="col-xs-1">
                <col class="col-xs-1">
                <col class="col-xs-1">
              </colgroup>
              <tbody>
                <tr>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="article" <?php if(in_array('article',$model->access)){?>checked<?php }?>> 新闻管理
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="articleCategory" <?php if(in_array('articleCategory',$model->access)){?>checked<?php }?>> 新闻分类管理
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="product" <?php if(in_array('product',$model->access)){?>checked<?php }?>> 产品管理
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="productCategory" <?php if(in_array('productCategory',$model->access)){?>checked<?php }?>> 产品分类管理
                    </label>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="about" <?php if(in_array('about',$model->access)){?>checked<?php }?>> 关于我们
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="job" <?php if(in_array('job',$model->access)){?>checked<?php }?>> 招贤纳士
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="link" <?php if(in_array('link',$model->access)){?>checked<?php }?>> 广告管理
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="adCategory" <?php if(in_array('adCategory',$model->access)){?>checked<?php }?>> 广告位管理
                    </label>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="link" <?php if(in_array('link',$model->access)){?>checked<?php }?>> 友情链接
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="sys" <?php if(in_array('sys',$model->access)){?>checked<?php }?>> 系统基本设置
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="route" <?php if(in_array('route',$model->access)){?>checked<?php }?>> 路由配置
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="pagecache" <?php if(in_array('pagecache',$model->access)){?>checked<?php }?>> 页面缓存
                    </label>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="database" <?php if(in_array('database',$model->access)){?>checked<?php }?>> 数据备份
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="custom_service" <?php if(in_array('custom_service',$model->access)){?>checked<?php }?>> 在线客服
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="qiniu" <?php if(in_array('qiniu',$model->access)){?>checked<?php }?>> 七牛云存储
                    </label>
                  </td>
                  <td>
                    <label class="checkbox-inline">
                      <input type="checkbox" name="AdminRole[access][]" value="manager" <?php if(in_array('manager',$model->access)){?>checked<?php }?>> 管理员设置
                    </label>
                  </td>
                </tr>
              </tbody>
            </table>
        </div>
    </div>
    <?php }?>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
            <?php if(!$model->super){?>
            <?= Html::submitButton($model->isNewRecord ? '添加' : '保存', ['class' => 'btn btn-primary']) ?>
            <?php }?>
            <?= Html::button('返回', ['class' => 'btn btn-default','onclick'=>'javscript:location.href="'.Yii::$app->urlManager->createUrl('manager/role').'"']) ?>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>
