<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = '角色权限';
$this->params['breadcrumbs'][] = ['label' => '角色权限', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation"><a href="<?php echo Yii::$app->urlManager->createUrl(['manager/index']);?>">管理员列表</a></li>
  <li role="presentation" class="active"><a>角色权限</a></li>
</ul>
<?php Pjax::begin(); ?>    
<?= GridView::widget([
        'dataProvider' => $dataProvider,
        'layout' => "{items}\n{pager}" ,
        'columns' => [
            'name',
            [
                'header' => "操作",
                'class' => 'yii\grid\ActionColumn',
                'template'=> '{update} {delete}',
                'headerOptions' => ['width' => '140'],
                'buttons' => [
                    'update' => function ($url, $model, $key){
                          return Html::a('编辑', ['manager/role-update','id'=>$model->id], ["class" => "btn btn-xs btn-info"]);
                    },
                    'delete' => function ($url, $model, $key) {
                            return Html::a("删除", ["manager/role-delete", "id" => $model->id], ["class" => "btn btn-xs btn-danger","onclick"=>"javascript:return confirm('确定删除吗？');"]);
                    }
                ]
            ],
        ],
    ]); ?>
<?php Pjax::end(); ?>
<?= Html::a('添加角色', ['role-create'], ['class' => 'btn btn-success']) ?>
