<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use common\components\CHelper;
use backend\assets\AppAsset; 
$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 
$this->title = '路由设置';
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>路由设置</a></li>
  <li role="presentation"><a href="<?php echo Yii::$app->urlManager->createUrl('route/rule');?>">路由规则</a></li>
</ul>
    
<div class="sys-form">
    <form method="post" action="<?php echo Yii::$app->urlManager->createUrl(['route/index']);?>" class="form-horizontal" enctype='multipart/form-data'>
    <input type="hidden" name="_csrf-backend" value="<?=Yii::$app->request->getCsrfToken() ?>">
    <div class="form-group">
        <label class="col-sm-2 control-label">是否开启</label>
        <div class="col-sm-3">
            <label class="radio-inline"><input type="radio" name="enablePrettyUrl" value="true" <?php if($list['enablePrettyUrl']['value']=='true'){?>checked<?php }?>>开启</label>
            <label class="radio-inline"><input type="radio" name="enablePrettyUrl" value="false" <?php if($list['enablePrettyUrl']['value']=='false'){?>checked<?php }?>>关闭</label>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">是否显示入口脚本</label>
        <div class="col-sm-3">
            <label class="radio-inline"><input type="radio" name="showScriptName" value="true" <?php if($list['showScriptName']['value']=='true'){?>checked<?php }?>>显示</label>
            <label class="radio-inline"><input type="radio" name="showScriptName" value="false" <?php if($list['showScriptName']['value']=='false'){?>checked<?php }?>>隐藏</label>
        </div>
    </div>
	<div class="form-group">
        <label class="col-sm-2 control-label">URL后缀</label>
        <div class="col-sm-2">
            <input type="text" name="suffix" class="form-control" value="<?php echo $list['suffix']['value']?>">
        </div>
    </div>
	<div class="form-group">
        <label class="col-sm-2 control-label">是否开启严格解析</label>
        <div class="col-sm-3">
            <label class="radio-inline"><input type="radio" name="enableStrictParsing" value="true" <?php if($list['enableStrictParsing']['value']=='true'){?>checked<?php }?>>开启</label>
            <label class="radio-inline"><input type="radio" name="enableStrictParsing" value="false" <?php if($list['enableStrictParsing']['value']=='false'){?>checked<?php }?>>关闭</label>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
        	<input type="submit" name="" value="保存" class="btn btn-primary">
        </div>
    </div>
    </form>
</div>
