<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\components\CHelper;
use backend\assets\AppAsset; 
$this->registerCssFile('@web/css/form.css');
AppAsset::register($this); 
$this->title = '系统设置';
$this->params['breadcrumbs'][] = ['label' => '系统设置', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<ul class="nav nav-tabs c-nav">
  <li role="presentation" class="active"><a>系统设置</a></li>
</ul>
    
<div class="sys-form">
    <form method="post" action="<?php echo Yii::$app->urlManager->createUrl(['sys/index']);?>" class="form-horizontal" enctype='multipart/form-data'>
    <input type="hidden" name="_csrf-backend" value="<?=Yii::$app->request->getCsrfToken() ?>">
	<div class="form-group">
        <label class="col-sm-2 control-label">网站域名</label>
        <div class="col-sm-3">
            <input type="text" name="sitedomain" class="form-control" value="<?php echo $list['sitedomain']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">网站安装目录</label>
        <div class="col-sm-3">
            <input type="text" name="sitedir" class="form-control" value="<?php echo $list['sitedir']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">网站名称</label>
        <div class="col-sm-3">
            <input type="text" name="sitename" class="form-control" value="<?php echo $list['sitename']['value']?>">
        </div>
    </div>
	<div class="form-group">
        <label class="col-sm-2 control-label">备案信息</label>
        <div class="col-sm-3">
            <input type="text" name="icp" class="form-control" value="<?php echo $list['icp']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">底部联系电话</label>
        <div class="col-sm-3">
            <input type="text" name="tel" class="form-control" value="<?php echo $list['tel']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">底部联系邮箱</label>
        <div class="col-sm-3">
            <input type="text" name="email" class="form-control" value="<?php echo $list['email']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">底部联系地址</label>
        <div class="col-sm-3">
            <input type="text" name="address" class="form-control" value="<?php echo $list['address']['value']?>">
        </div>
    </div>
    <?php
        if($list['logo']['value']){
    ?>
    <div class="form-group">
        <label class="col-sm-2 control-label">已上传Logo</label>
        <div class="col-sm-6">
            <img src="<?php echo CHelper::attach($list['logo']['value'],'logo');?>" class="img-thumbnail" width="200">
        </div>
    </div>
    <?php }?>
    <div class="form-group">
        <label class="col-sm-2 control-label">网站Logo</label>
        <div class="col-sm-3">
            <input type="file" name="Config[logo]" class="form-control" value="<?php echo $list['logo']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">最大上传文件</label>
        <div class="col-sm-2">
            <div class="input-group">
              <input type="text" name="upload_file_max" class="form-control" value="<?php echo $list['upload_file_max']['value']?>">
              <div class="input-group-addon">MB</div>
            </div>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">第三方统计代码</label>
        <div class="col-sm-5">
            <textarea name="statistics" class="form-control"><?php echo $list['statistics']['value']?></textarea>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">seo标题</label>
        <div class="col-sm-5">
            <input type="text" name="seo_title" class="form-control" value="<?php echo $list['seo_title']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">seo关键字</label>
        <div class="col-sm-5">
            <input type="text" name="seo_keywords" class="form-control" value="<?php echo $list['seo_keywords']['value']?>">
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label">seo描述</label>
        <div class="col-sm-5">
            <textarea name="seo_description" class="form-control"><?php echo $list['seo_description']['value']?></textarea>
        </div>
    </div>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-6">
        	<input type="submit" name="" value="保存" class="btn btn-primary">
        </div>
    </div>

    </form>

</div>
