<?php

namespace common\models;

use Yii;
use common\components\CHelper;

/**
 * This is the model class for table "{{%article}}".
 *
 * @property string $id
 * @property string $uid
 * @property string $author
 * @property string $cid
 * @property string $cname
 * @property string $title
 * @property string $content
 * @property integer $display
 * @property string $addtime
 * @property string $updatetime
 */
class Article extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%article}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'title', 'content', 'display'], 'required'],
            [['uid', 'cid', 'display', 'addtime', 'updatetime','ordid'], 'integer'],
            [['content','url'], 'string'],
            [['author', 'cname', 'title'], 'string', 'max' => 30],
            [['thumb','seo_title','seo_keywords','seo_description'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'uid' => 'Uid',
            'author' => '作者',
            'cid' => '类型',
            'cname' => '类型',
            'title' => '标题',
            'content' => '内容',
            'thumb' => '缩略图',
            'display' => '显示/隐藏',
            'addtime' => '发布时间',
            'updatetime' => '更新时间',
            'ordid' => '排序',
            'click'=>'点击量',
            'seo_title' => 'seo标题',
            'seo_keywords' => 'seo关键字',
            'seo_description' => 'seo描述',
            'url'=>'跳转指定URL',
        ];
    }
    public function beforeSave($insert)
    {
        $timestamp = time();
        if (parent::beforeSave($insert)) {
            if($this->cid){
                $this->cname = ArticleCategory::getCache($this->cid);
            }
            if(!$this->click){
                $this->click = 0;
            }
            if(!$this->seo_title){
                $this->seo_title = $this->title;
            }
            if(!$this->seo_keywords){
                $seo_keywords = CHelper::getTags($this->title.strip_tags($this->content));
                $seo_keywords = array_unique($seo_keywords);
                $count_num = count($seo_keywords)>10?10:count($seo_keywords);
                $arr = array();
                for ($i=0; $i < $count_num; $i++) { 
                    $arr[] = $seo_keywords[$i];
                }
                $this->seo_keywords = implode(',',$arr);
            }
            if(!$this->seo_description){
                $this->seo_description = CHelper::cutStr(strip_tags($this->content),100);
            }
            if($insert) {
                $this->uid = Yii::$app->user->id;
                $this->author = Yii::$app->user->identity->username;
                $this->addtime = $timestamp;
                $this->updatetime = $timestamp;
                $this->ordid = 0;
            }
            return true;
        } else {
            return false;
        }
    }
}
