<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%config}}".
 *
 * @property string $id
 * @property string $name
 * @property string $value
 */
class Config extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%config}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'value'], 'required'],
            [['value'], 'string'],
            [['name'], 'string', 'max' => 30],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'value' => 'Value',
        ];
    }
    public static function updateCache(){
        $data = self::find()->asArray()->all();
        $content = "<?php\nreturn [\n";
        foreach ($data as $key => $value) {
            $content .= "\"".$value['name']."\"=>\"".$value['value']."\",\n";
        }
        $content .= "];";
        file_put_contents(COMMON_CONF_PATH.'config.php',$content);
        return true;
    }
}
