<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "{{%link}}".
 *
 * @property string $id
 * @property integer $display
 * @property string $link_name
 * @property string $link_url
 * @property string $link_logo
 * @property integer $ordid
 * @property string $notes
 */
class Link extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%link}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['display','type', 'link_name', 'link_url'], 'required'],
            [['display','type', 'ordid'], 'integer'],
            [['link_name', 'link_url', 'link_logo', 'notes'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'display' => '显示/隐藏',
            'type' => '类型',
            'link_name' => '链接标题',
            'link_url' => '地址',
            'link_logo' => 'Logo',
            'ordid' => '排序',
            'notes' => '备注',
        ];
    }
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            !$this->ordid && $this->ordid = 0;
            return true;
        } else {
            return false;
        }
    }
}
