<?php
namespace frontend\controllers;

use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\data\Pagination;
use common\models\About;
use common\components\CHelper;

class AboutController extends Controller
{

    public function behaviors()
    {
        $pagecache = \common\models\Pagecache::getCache();
        return [
            [
                'class' => 'yii\filters\PageCache',
                'enabled'=>$pagecache['about']['status']==1?true:false,
                'only' => ['detail'],
                'duration' => $pagecache['about']['time'],
                'variations'=>[Yii::$app->request->get('id')],
                'dependency' => [
                    'class' => 'yii\caching\DbDependency',
                    'sql' => 'SELECT updatetime FROM '.Yii::$app->db->tablePrefix.'about where `id`='.Yii::$app->request->get('id'),
                ],
            ],
        ];
    }
    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionDetail($id){
        $model = $this->findModel($id);
        return $this->render('detail',[
            'model'=>$model,
        ]);
    }
    protected function findModel($id)
    {
        if (($model = About::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
