<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use frontend\assets\AppAsset;
use frontend\components\CLinkPager;

AppAsset::register($this);
$this->registerCssFile($this->theme->getUrl('css/news.css'));
$this->seo_title = $category;
$this->seo_keywords = $category;
$this->seo_description = $category;
?>
<div class="row">
  <div class="col-md-3">
    <?= frontend\widgets\NewsCategoryWidget::widget();?>
    <?= frontend\widgets\HotnewsWidget::widget();?>
  </div>
  <div class="col-md-9">
    <div class="container-fluid news-list">
    <?php foreach($list as $key=>$value){?>
      <div class="row news-item">
        <div class="col-md-3">
            <a href="<?php echo $value['url'];?>" target="<?php echo $value['target'];?>" class="thumbnail news-thumb">
              <img src="<?php echo $value['thumb'];?>" alt="<?php echo Html::encode($value['title']);?>">
            </a>
        </div>
        <div class="col-md-9">
            <div class="row title"><h4><a href="<?php echo $value['url'];?>" target="<?php echo $value['target'];?>" title="<?php echo Html::encode($value['title']);?>"><?php echo Html::encode($value['title']);?></a></h4></div>
            <div class="row des"><?php echo Html::encode($value['brief']);?></div>
            <div class="row info">
                <span>更新时间：<?php echo date('Y-m-d',$value['updatetime']);?></span>
                <span>作者：<?php echo Html::encode($value['author']);?></span>
                <span>浏览量：<?php echo $value['click'];?></span>
             </div>
        </div>
      </div>
      <?php }?>
    </div>
    <?= CLinkPager::widget(['pagination' => $pages]); ?>
  </div>
</div>