<?php
namespace frontend\widgets;

use Yii;
use yii\base\Widget;
use common\models\About;
use common\components\CHelper;
use yii\helpers\Html;
class AboutWidget extends Widget
{
    public $limit;
    public $active_id;
    
    public function init()
    {
        parent::init();
        $this->limit = $this->limit?$this->limit:100;
        $this->active_id = $this->active_id?$this->active_id:0;
    }
    
    public function run()
    {
    	$data = About::find()->andWhere(['display'=>1]);
        $list = $data->asArray()->orderBy('ordid desc,id asc')->limit($this->limit)->all();
        $list = $this->_format_list($list);
    	return $this->render('/widgets/about',[
    		'list'=>$list,
            'active_id'=>$this->active_id,
    	]);
    }
    private function _format_list($list){
        foreach ($list as $key => $value) {
        	$list[$key]['title'] = Html::encode(CHelper::cutStr($value['title'],15));
            $list[$key]['url'] = Yii::$app->urlManager->createUrl(['about/detail','id'=>$value['id']]);
        }
        return $list;
    }
}