<?php

use yii\db\Migration;

class m170523_070338_config extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%config}}', [
            'id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT',
            'name' => 'varchar(30) NOT NULL',
            'value' => 'text NOT NULL',
            'note' => 'varchar(30) NOT NULL',
            'PRIMARY KEY (`id`)'
        ], "ENGINE=MyISAM  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        
        
        /* 表数据 */
        $this->insert('{{%config}}',['id'=>'1','name'=>'sitename','value'=>'云朵CMS','note'=>'网站名称']);
        $this->insert('{{%config}}',['id'=>'2','name'=>'icp','value'=>'icp000000000','note'=>'备案信息']);
        $this->insert('{{%config}}',['id'=>'3','name'=>'address','value'=>'xx省xx市xx区xx路000号','note'=>'联系地址']);
        $this->insert('{{%config}}',['id'=>'4','name'=>'logo','value'=>'','note'=>'网站Logo']);
        $this->insert('{{%config}}',['id'=>'5','name'=>'qiniu_open','value'=>'0','note'=>'']);
        $this->insert('{{%config}}',['id'=>'6','name'=>'qiniu_accessKey','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'7','name'=>'qiniu_secretKey','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'8','name'=>'qiniu_bucket','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'9','name'=>'qiniu_domain','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'10','name'=>'enablePrettyUrl','value'=>'false','note'=>'是否开启URL美化功能']);
        $this->insert('{{%config}}',['id'=>'11','name'=>'showScriptName','value'=>'false','note'=>'是否在URL中显示入口脚本']);
        $this->insert('{{%config}}',['id'=>'12','name'=>'suffix','value'=>'','note'=>'URL后缀']);
        $this->insert('{{%config}}',['id'=>'13','name'=>'enableStrictParsing','value'=>'false','note'=>'是否开启严格解析']);
        $this->insert('{{%config}}',['id'=>'15','name'=>'news_no_thumb','value'=>'news_no_thumb.jpg','note'=>'']);
        $this->insert('{{%config}}',['id'=>'16','name'=>'sitedir','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'17','name'=>'product_no_thumb','value'=>'product_no_thumb.jpg','note'=>'']);
        $this->insert('{{%config}}',['id'=>'18','name'=>'upload_file_max','value'=>'8','note'=>'']);
        $this->insert('{{%config}}',['id'=>'19','name'=>'sitedomain','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'20','name'=>'statistics','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'21','name'=>'seo_title','value'=>'云朵CMS - 高端企业建站系统(www.yunduocms.com)','note'=>'']);
        $this->insert('{{%config}}',['id'=>'22','name'=>'seo_keywords','value'=>'云朵CMS,建站,企业建站,企业cms源码,企业网站建设,php内容管理系统','note'=>'']);
        $this->insert('{{%config}}',['id'=>'23','name'=>'seo_description','value'=>'云朵CMS是基于PHP+MYSQL的免费企业网站管理系统，提供完善的企业网站建设方案。','note'=>'']);
        $this->insert('{{%config}}',['id'=>'24','name'=>'custom_service_open','value'=>'0','note'=>'']);
        $this->insert('{{%config}}',['id'=>'25','name'=>'email','value'=>'','note'=>'']);
        $this->insert('{{%config}}',['id'=>'26','name'=>'tel','value'=>'000-00000000','note'=>'']);
        $this->insert('{{%config}}',['id'=>'27','name'=>'weixin_qrcode','value'=>'weixin_qrcode.png','note'=>'']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%config}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

