<?php

use yii\db\Migration;

class m170523_070338_link extends Migration
{
    public function up()
    {
        /* 取消外键约束 */
        $this->execute('SET foreign_key_checks = 0');
        
        /* 创建表 */
        $this->createTable('{{%link}}', [
            'id' => 'int(10) unsigned NOT NULL AUTO_INCREMENT',
            'type' => 'tinyint(1) unsigned NOT NULL DEFAULT \'0\'',
            'display' => 'tinyint(1) unsigned NOT NULL',
            'link_name' => 'varchar(255) NOT NULL',
            'link_url' => 'varchar(255) NOT NULL',
            'link_logo' => 'varchar(255) NOT NULL',
            'ordid' => 'smallint(5) unsigned NOT NULL DEFAULT \'0\'',
            'notes' => 'varchar(255) NULL',
            'PRIMARY KEY (`id`)'
        ], "ENGINE=MyISAM  DEFAULT CHARSET=utf8");
        
        /* 索引设置 */
        $this->createIndex('show_order','{{%link}}','ordid',0);
        
        
        /* 表数据 */
        $this->insert('{{%link}}',['id'=>'9','type'=>'1','display'=>'1','link_name'=>'云朵CMS','link_url'=>'http://www.yunduocms.com','link_logo'=>'2017/05/07/52121494166506.png','ordid'=>'999','notes'=>'']);
        
        /* 设置外键约束 */
        $this->execute('SET foreign_key_checks = 1;');
    }

    public function down()
    {
        $this->execute('SET foreign_key_checks = 0');
        /* 删除表 */
        $this->dropTable('{{%link}}');
        $this->execute('SET foreign_key_checks = 1;');
    }
}

