<?php

namespace install\models;

use Yii;
use yii\base\Model;
use common\models\Admin;

class CreateManagerForm extends Model
{
    public $admin_username;
    public $admin_password;
    public $admin_password_repeat;
    public $admin_email;


    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            // name, email, subject and body are required
            [['admin_username','admin_password','admin_password_repeat','admin_email'], 'required'],
            // email has to be a valid email address
            ['admin_email', 'email'],
            [['admin_password'], 'string', 'min' => 6],
            [['admin_password_repeat'], 'compare','compareAttribute'=>'admin_password','message'=>'两次输入的密码不一致'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'admin_username' => '管理员用户名',
            'admin_password' => '管理员密码',
            'admin_password_repeat' => '确认密码',
            'admin_email' => '电子邮箱',
        ];
    }
    public function createManager(){
        $model = new Admin();
        $model->scenario = 'create';
        $model->username = $this->admin_username;
        $model->password = $this->admin_password;
        $model->nickname = $this->admin_username;
        $model->status = 1;
        $model->role = 1;
        $model->super = 1;
        $model->setPassword($model->password);
        $model->generateAuthKey();
        $model->generatePasswordResetToken();
        if($model->save()){
            return array('status'=>1);
        }else{
            $error = $model->getErrors();
            return array('status'=>0,'msg'=>$error[0]);
        }
    }
}
