<?php

/**
 *--------------------------------------
 * admin common function library
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-28
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

function get_limitPermission($parse = false) {
	/* localhost or licenced LOGA is not limit */
	$_licence = function_exists('get_licence') ? get_licence() : null;
	if('127.0.0.1' == CLIENT_IP or !empty($_licence)) {
		return array('_none');
	}

	$_LP = array();
	$_t_lp = unserialize(ACrypt::decrypt('1da50Eczt3SAfR2j6ic64O0H7OafBWRXvkA6ziYCgmrjALixSjf8CpjhG5YmDVcq3qinI83aLX9oTNEpRPC36wMk3ol9WPHXxBt0HpBnNrYNfB7CJaDkGbordTPOrJ2kzvKXZj7zTEZXvNxQXwpeBha+pksnPEXZDVEv3FXtLpn/DG++l9uQ/ROMriAWVD+tX37hTd3LitKL+wlRTapmz38hBa54TMPnl8geiyTQ/wjOwNCYzjRCRfn8anm8c9LzO6LB3ZKP2tZ6nOSOzRDCiHoikVKpsiYd35H4b97dIqqU7kEeDhXyQ5SbkzcUrYGnpEgrF2rRsPU5CXzo5EYpd1StyGFuYH+QF4LmRMiFVxtokfRKNXgWY5Wqsoo3iOBmLe8gwEgpY48fLc28bPzOot95d1DZ6CNT25sntElsdMxaVErbciI4kiFVBy7ARAOvUHOZOku1cDfZSQOFnrgzMUQFNsMj0UHYwk4LsEsorD2xSvdQU4bkiyySl4sdPwzP634F5Pf9IxIQqC0bjKw9R5GrZ0BDfgmPS7ZI2h1w08k1M9mRxqMCcTWja7ldvdgpbzQn6YdwpiLCmtRNX+WYwf0qdnxP45ONwFh5QI7yadJLO0+VH8nK8xOSqBTwxQC49gfK5rkBxMsKmPioZ6EVj+LpoxGr/WSVXW6ejlPi/wt6+jR6DEigQemtJJjN6+nETW9rBMbqzRPGDP4t/xDObKTzLkrWxnhtG0X1c//U51b4rn/MrZil4E1p47j/vl+f8cXL5wu3pPB78e/U4lg+8bpPf5PIMKfVPIrH5xKuj/Q0Ft28FzHj6PaLHuISfRkJvcN0qGc3UGrjTQDjYTzmJXsojHP0Dw40ID0Lvmf9cOw0dmSbYGVLEsGn5b4oOIhycawSssEP3pOc3Hr/Hqgw1y9cURTayVrr2SeBVpH9Z88+YpRI06qR4LI/YOjo08gmSIXFSleEkjLrkakaDuZQchCm37mrikcixCTmd+owq/KfdXqZjFNiaZ9pFDBdtApVpj5DuBtIwSfjfj6ug8f1fg/HvgOsASxpI2zz27doShoCatNSbFptGKvDbLTRPGw', SOFT_NAME));
	if('yes' != $_t_lp['v']) {
		return array('_all');
	}
	foreach($_t_lp['p'] as $ap) {
		if($parse and strpos($ap, ':')) {
			$_p = explode(':', $ap);
			$_LP[] = parse_name($_p[0]).'/'.$_p[1];
		}
		else {
			$_LP[] = $ap;
		}
	}
	return $_LP;
}

/* get controller list from path */
function get_ctrlrList($ctrlrPath) {
	$names = include_cache($ctrlrPath.'/_names.php');
	$ctrlrList = array();
	$dirRes = opendir($ctrlrPath);
	while($dir = readdir($dirRes)) {
		if(!in_array($dir, array(
			'.',
			'..',
			'index.html',
			'_names.php',
			'.svn'))) {
			$ctrlr = basename($dir, 'Ctrlr.class.php');
			$name = isset($names[$ctrlr]) ? $names[$ctrlr] : $ctrlr;
			$ctrlrList[] = array('ctrlr' => $ctrlr, 'name' => $name);
		}
	}
	return $ctrlrList;
}

/* get action list from controller */
function get_actnList($ctrlr) {
	$ctrlrClass = $ctrlr.'Ctrlr';
	$baseCtrlr = get_class_methods('Ctrlr');
	$advCtrlr = get_class_methods($ctrlrClass);
	$actnList = array_diff($advCtrlr, $baseCtrlr);
	return $actnList;
}

/* get action list from file */
function get_fileActnList($file) {
	$arr = file($file);
	foreach($arr as $line) {
		if(preg_match('/function ([_A-Za-z0-9]+)/i', $line, $regs)) {
			$arr_methods[] = $regs[1];
		}
	}
	return $arr_methods;
}

/* get child directory list, $exclude: exclude dir */
function list_dir($dir, $exclude = array()) {
	$items = array();

	if(empty($dir)) {
		return $items;
	}

	$files = glob(rtrim($dir, '/\\').D_S.'*');
	if(is_array($files)) {
		$names = include_cache($dir.'/_names.php');
		foreach($files as $v) {
			if(is_file($v) or in_array(basename($v), $exclude)) {
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('dir' => $v, 'name' => $n);
		}
	}
	return $items;
}

/* get child file list, $exclude: exclude file */
function list_file($dir, $exclude = array('_names.php')) {
	$items = array();

	if(empty($dir)) {
		return $items;
	}

	$files = glob(rtrim($dir, '/\\').D_S.'*');
	if(is_array($files)) {
		$names = include_cache($dir.'/_names.php');
		foreach($files as $v) {
			if(!is_file($v) or in_array(basename($v), $exclude)) {
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('file' => $v, 'name' => $n);
		}
	}
	return $items;
}

/* save extension option $extensionAlias */
function edit_extensionOption($extensionAlias, $option) {
	if(MAGIC_QUOTES_GPC) {
		$option = stripslashes_array($option);
	}
	if(C('URL.LANG_SUFFIX')) {
		unset($option[C('VAR.LANG')]);
	}

	$cfgFile = CFG_PATH.D_S.'Extension'.D_S.parse_name($extensionAlias, 1).'.php';

	$_O = include($cfgFile);
	$_O = empty($_O) ? $option : array_merge($_O, $option);

	$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($_O, true).";\r\n?>";

	return @file_put_contents($cfgFile, $content);
}

?>