<?php

/**
 *--------------------------------------
 * encode file function library
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-20
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

/* get encode content from file list */
function get_fileListEncode($fileList = '') {
	$files = array();
	if(empty($fileList)) {
		return $files;
	}
	$fileList = trim_array(explode("\n", $fileList));
	foreach($fileList as $filename) {
		$filename = rtrim(str_replace(ROOT_PATH, '{root_path}', $filename), '/\\');
		if(0 !== strpos($filename, '{root_path}') or false !== strpos($filename, '..')) {
			continue;
		}

		$_filename = str_replace('{root_path}', ROOT_PATH, $filename);
		if(is_dir($_filename)) {
			$_fileList = get_fileList($_filename);
			foreach($_fileList as $f) {
				$files = array_merge($files, get_fileListEncode($f));
			}
		}
		elseif(is_file($_filename)) {
			$content = get_fileEncode($_filename);
			$files[] = array(
				'filename' => $filename,
				'content' => $content,
				);
		}
	}
	return $files;
}

/* get encode content from file */
function get_fileEncode($filename, $delete = false) {
	if(!file_exists($filename) or !is_file($filename)) {
		return '';
	}
	$code = file_get_contents($filename);
	if(!empty($code)) {
		if($delete) {
			@unlink($filename);
		}
		return base64_encode($code);
	}
	return '';
}

/* output loga package */
function output_logaPackage($filename, $content = '', $compressed = true) {
	header('Content-Encoding: none');
	header('Pragma: no-cache');
	header('Expires: 0');
	if($compressed) {
		header('Content-Type: application/zip');
		header('Content-Disposition: attachment; filename='.$filename);
		echo gzencode($content);
	}
	else {
		header('Content-Type: application/octet-stream');
		header('Accept-Ranges: bytes');
		//header('Accept-Length: '.filesize($file_dir.$filename));
		header('Content-Disposition: attachment; filename='.$filename);
		echo $content;
	}
	exit;
}

/* define gzdecode function */
if(!function_exists('gzdecode')) {
	function gzdecode($data) {
		$flags = ord(substr($data, 3, 1));
		$headerlen = 10;
		$extralen = 0;
		$filenamelen = 0;
		if($flags & 4) {
			$extralen = unpack('v', substr($data, 10, 2));
			$extralen = $extralen[1];
			$headerlen += 2 + $extralen;
		}
		if($flags & 8) { // Filename
			$headerlen = strpos($data, chr(0), $headerlen) + 1;
		}
		if($flags & 16) { // Comment
			$headerlen = strpos($data, chr(0), $headerlen) + 1;
		}
		if($flags & 2) { // CRC at end of file
			$headerlen += 2;
		}
		$unpacked = @gzinflate(substr($data, $headerlen));
		if($unpacked === false) {
			$unpacked = $data;
		}
		return $unpacked;
	}
}

?>