<?php

/**
 *--------------------------------------
 * article review
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleReviewCtrlr extends ManageCtrlr {
	public function edit_option() {
		$this->assign('_O', EO('article_review'));

		$this->display('article_review/edit_option');
	}
	public function edit_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		unset($data['timeKey']);
		unset($data['token']);

		if(!edit_extensionOption('article_review', $data)) {
			M('Log')->add_log(L('EDIT_ARTICLE_REVIEW_OPTION').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('article_review/edit_option'));
		}
		M('Log')->add_log(L('EDIT_ARTICLE_REVIEW_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('article_review/edit_option'));
	}

	public function list_review() {
		$where = array();

		/* check permission */
		$articleCategoryId = ARequest::get('article_category_id') ? ARequest::get('article_category_id') : 0;
		if($articleCategoryId > 0) {
			$_ACL = M('ArticleCategory')->get_categoryList();
			$act = new ATree($_ACL, array('article_category_id', 'ac_parent_id', 'ac_sub_category'));
			$where['__ARTICLE_REVIEW__.article_category_id'] = array('IN', implode(',', $act->get_leafid($articleCategoryId)));
		}

		/* archvie id */
		$articleId = ARequest::get('article_id') ? ARequest::get('article_id') : 0;
		if($articleId > 0) {
			$where['__ARTICLE_REVIEW__.article_id'] = array('EQ', $articleId);
		}

		/* filter status */
		$arStatus = ARequest::get('ar_status') ? ARequest::get('ar_status') : '';
		if('n' == $arStatus) {
			$where['ar_status'] = array('EQ', 0);
		}
		elseif('p' == $arStatus) {
			$where['ar_status'] = array('EQ', 1);
		}
		elseif('f' == $arStatus) {
			$where['ar_status'] = array('EQ', 2);
		}

		/* filter content */
		$arContent = ARequest::get('ar_content');
		if(!empty($arContent)) {
			$where['ar_content'] = array('LIKE', '%'.$arContent.'%');
		}

		/* get paging and list */
		$_PG = '';
		$_ARL = '';
		$rowsNum = M('ArticleReview')->get_reviewCount($where);
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'article_review_id';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'desc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('article_review/list_review?article_category_id='.$articleCategoryId.'&article_id='.$articleId.'&ar_status='.$arStatus.'&ar_content='.$arContent.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_ARL = M('ArticleReview')->get_reviewList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit(), false);
		}
		$this->assign('_PG', $_PG);
		$this->assign('_ARL', $_ARL);

		$this->display('article_review/list_review');
	}

	public function edit_review() {
		$articleReviewId = ARequest::get('article_review_id');
		$_ARI = M('ArticleReview')->get_reviewInfo($articleReviewId, true);
		if(empty($_ARI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('article_review/list_review'));
		}

		$this->assign('_ARI', $_ARI);

		$this->display('article_review/edit_review');
	}
	public function edit_review_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$data['ar_content'] = str_replace(array("\r\n", "\n"), "<br />", AFilter::text($data['ar_content']));
		$data['ar_qoute'] = str_replace(array("\r\n", "\n"), "<br />", AFilter::text($data['ar_qoute']));

		$result = M('ArticleReview')->edit_review($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_ARTICLE_REVIEW').': ID['.$data['article_review_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('article_review/list_review'));
		}

		M('Log')->add_log(L('EDIT_ARTICLE_REVIEW').': ID['.$data['article_review_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('article_review/list_review'));
	}

	public function pass_review_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleReviewId = ARequest::get('article_review_id');
		$articleReviewId = is_array($articleReviewId) ? $articleReviewId : explode(',', $articleReviewId);
		$_L_ID = implode(', ', $articleReviewId);

		foreach($articleReviewId as $articleReviewId) {
			$data = array();
			$data['article_review_id'] = $articleReviewId;
			$data['ar_status'] = 1;

			$result = M('ArticleReview')->edit_review($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('PASS_ARTICLE_REVIEW').': ID['.$articleReviewId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_review/list_review'));
			}
		}

		M('Log')->add_log(L('PASS_ARTICLE_REVIEW').': ID['.$_L_ID.']');
		$this->success(L('PASS_SUCCESS'), Url::U('article_review/list_review'));
	}

	public function toggle_review_status_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = array();
		$data['article_review_id'] = ARequest::get('article_review_id');
		$data['ar_status'] = ARequest::get('ar_status');

		$result = M('ArticleReview')->edit_review($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_ARTICLE_REVIEW').': ID['.$data['article_review_id'].']', 0);
			$this->error(L('TOGGLE_FAILED'), Url::U('article_review/list_review'));
		}

		M('Log')->add_log(L('EDIT_ARTICLE_REVIEW').': ID['.$data['article_review_id'].']');
		$this->success(L('TOGGLE_SUCCESS'), Url::U('article_review/list_review'));
	}

	public function delete_review_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleReviewId = ARequest::get('article_review_id');
		$articleReviewId = is_array($articleReviewId) ? $articleReviewId : explode(',', $articleReviewId);
		$_L_ID = implode(', ', $articleReviewId);

		foreach($articleReviewId as $articleReviewId) {
			$result = M('ArticleReview')->delete_review($articleReviewId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_ARTICLE_REVIEW').': ID['.$articleReviewId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_review/list_review'));
			}
		}

		M('Log')->add_log(L('DELETE_ARTICLE_REVIEW').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('article_review/list_review'));
	}

	public function delete_same_ip_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$articleReviewId = ARequest::get('article_review_id');
		$articleReviewId = is_array($articleReviewId) ? $articleReviewId : explode(',', $articleReviewId);
		$_L_ID = implode(', ', $articleReviewId);

		foreach($articleReviewId as $articleReviewId) {
			$result = M('ArticleReview')->delete_sameIp($articleReviewId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_ARTICLE_REVIEW').': ID['.$articleReviewId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('article_review/list_review'));
			}
		}

		M('Log')->add_log(L('DELETE_ARTICLE_REVIEW').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('article_review/list_review'));
	}
}

?>