<?php

/**
 *--------------------------------------
 * flink
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-08-20
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FlinkCtrlr extends ManageCtrlr {
	public function edit_option() {
		$this->assign('_O', EO('flink'));

		$this->display('flink/edit_option');
	}
	public function edit_option_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		unset($data['timeKey']);
		unset($data['token']);

		if(!edit_extensionOption('flink', $data)) {
			M('Log')->add_log(L('EDIT_FLINK_OPTION').': '.L('SAVE_CFG_FILE_FAILED'), 0);
			$this->error(L('SAVE_CFG_FILE_FAILED'), Url::U('flink/edit_option'));
		}
		M('Log')->add_log(L('EDIT_FLINK_OPTION'));
		$this->success(L('EDIT_SUCCESS'), Url::U('flink/edit_option'));
	}

	public function list_flink() {
		/* flink category list */
		$_FCL = M('FlinkCategory')->get_categoryList();
		$this->assign('_FCL', $_FCL);

		$where = array();
		/* filter category */
		$fcAlias = ARequest::get('fc_alias') ? ARequest::get('fc_alias') : 0;
		if($fcAlias > 0) {
			$where['__FLINK__.fc_alias'] = array('EQ', $fcAlias);
		}

		/* filter show type */
		$fShowType = ARequest::get('f_show_type') ? ARequest::get('f_show_type') : '';
		if('t' == $fShowType) {
			$where['__FLINK__.f_show_type'] = array('EQ', 0);
		}
		elseif('l' == $fShowType) {
			$where['__FLINK__.f_show_type'] = array('EQ', 1);
		}

		/* filter status */
		$fStatus = ARequest::get('f_status') ? ARequest::get('f_status') : '';
		if('n' == $fStatus) {
			$where['__FLINK__.f_status'] = array('EQ', 0);
		}
		elseif('p' == $fStatus) {
			$where['__FLINK__.f_status'] = array('EQ', 1);
		}

		/* get paging and list */
		$_PG = '';
		$_FL = '';
		$rowsNum = M('Flink')->get_flinkCount($where);
		if(0 < $rowsNum) {
			$orderBy = ARequest::get('order_by') ? ARequest::get('order_by') : 'f_display_order';
			$orderTurn = ARequest::get('order_turn') ? ARequest::get('order_turn') : 'asc';
			$pageSize = (ARequest::get('page_size') > 0 ? ARequest::get('page_size') : 20);
			$p = new APage($rowsNum, $pageSize, Url::U('flink/list_flink?fc_alias='.$fcAlias.'&f_show_type='.$fShowType.'&f_status='.$fStatus.'&order_by='.$orderBy.'&order_turn='.$orderTurn.'&page_size='.$pageSize.'&'.C('VAR.PAGE').'=_page_'));
			$_PG = $p->get_paging();

			$_FL = M('Flink')->get_flinkList($where, "`{$orderBy}` {$orderTurn}", $p->get_limit());
		}
		$this->assign('_PG', $_PG);
		$this->assign('_FL', $_FL);

		$this->display('flink/list_flink');
	}

	public function add_flink() {
		$_FCL = M('FlinkCategory')->get_categoryList();
		$this->assign('_FCL', $_FCL);

		$this->display('flink/add_flink');
	}
	public function add_flink_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('Flink')->add_flink($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('ADD_FLINK').': '.$result['error'], 0);
			$this->error($result['error'], Url::U('flink/list_flink'));
		}

		M('Log')->add_log(L('ADD_FLINK').': ID['.$result['data'].']');
		$this->success(L('ADD_SUCCESS'), Url::U('flink/list_flink'));
	}

	public function edit_flink() {
		$flinkId = ARequest::get('flink_id');
		$_FI = M('Flink')->get_flinkInfo($flinkId);
		if(empty($_FI)) {
			$this->error(L('ITEM_INEXISTENCE'), Url::U('flink/list_flink'));
		}
		$this->assign('_FI', $_FI);

		/* flink category list */
		$_FCL = M('FlinkCategory')->get_categoryList();
		$this->assign('_FCL', $_FCL);

		$this->display('flink/edit_flink');
	}
	public function edit_flink_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = ARequest::get();
		$result = M('Flink')->edit_flink($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_FLINK').': ID['.$data['flink_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('flink/list_flink'));
		}
		M('Log')->add_log(L('EDIT_FLINK').': ID['.$data['flink_id'].']');
		$this->success(L('EDIT_SUCCESS'), Url::U('flink/list_flink'));
	}

	public function delete_flink_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$flinkId = ARequest::get('flink_id');
		$flinkId = is_array($flinkId) ? $flinkId : explode(',', $flinkId);
		$_L_ID = implode(', ', $flinkId);

		foreach($flinkId as $flinkId) {
			$result = M('Flink')->delete_flink($flinkId);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('DELETE_FLINK').': ID['.$flinkId.']'.$result['error'], 0);
				$this->error($result['error'], Url::U('flink/list_flink'));
			}
		}

		M('Log')->add_log(L('DELETE_FLINK').': ID['.$_L_ID.']');
		$this->success(L('DELETE_SUCCESS'), Url::U('flink/list_flink'));
	}

	public function toggle_flink_status_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$data = array();
		$data['flink_id'] = ARequest::get('flink_id');
		$data['f_status'] = ARequest::get('f_status');
		$result = M('Flink')->edit_flink($data);
		if(!empty($result['error'])) {
			M('Log')->add_log(L('EDIT_FLINK').': ID['.$data['flink_id'].']'.$result['error'], 0);
			$this->error($result['error'], Url::U('flink/list_flink'));
		}
		M('Log')->add_log(L('EDIT_FLINK').': ID['.$data['flink_id'].']');
		$this->success(L('TOGGLE_SUCCESS'), Url::U('flink/list_flink'));
	}

	public function update_flink_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$flinkId = ARequest::get('flink_id');
		$fDisplayOrder = ARequest::get('f_display_order');
		$_L_ID = is_array($flinkId) ? implode(', ', $flinkId) : $flinkId;

		if(!is_array($flinkId) or empty($flinkId)) {
			M('Log')->add_log(L('EDIT_FLINK').': ID['.$flinkId.']'.L('ITEM_INEXISTENCE'), 0);
			$this->error(L('ITEM_INEXISTENCE'), Url::U('flink/list_flink'));
		}

		$data = array();
		$error = false;
		foreach($flinkId as $k => $id) {
			$data['flink_id'] = $id;
			$data['f_display_order'] = $fDisplayOrder[$k];
			$result = M('Flink')->edit_flink($data);
			if(!empty($result['error'])) {
				M('Log')->add_log(L('EDIT_FLINK').': ID['.$flinkId.']', 0);
				$this->error(L('EDIT_FAILED'), Url::U('flink/list_flink'));
			}
		}

		M('Log')->add_log(L('EDIT_FLINK').': ID['.$_L_ID.']');
		$this->success(L('EDIT_SUCCESS'), Url::U('flink/list_flink'));
	}
}

?>