<?php

/**
 *--------------------------------------
 * manage index
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-27
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class IndexCtrlr extends ManageCtrlr {
	public function index() {
		$_M = M('Index')->get_manageMenu();
		$this->assign('_M', $_M);

		/* Shortcut List */
		$_SL = array();
		$_t_file = CFG_PATH.D_S.'Shortcut'.D_S.LANG_NAME.'.php';
		if(is_file($_t_file)) {
			$_SL = include_cache($_t_file);
		}
		$this->assign('_SL', $_SL);

		$this->display('index');
	}

	public function show_dashboard() {
		/* Site Safe Tips */
		$_SST = array();
		if(file_exists(ROOT_PATH.D_S.'admin.php')) {
			$_SST[] = L('MANAGEMENT_FILE_RENAMING_TIP');
		}
		if(file_exists(ROOT_PATH.D_S.'install')) {
			$_SST[] = L('INSTALL_DIR_EXIST_TIP');
		}
		$this->assign('_SST', $_SST);

		/* Shortcut */
		$_SL = array();
		$_t_file = CFG_PATH.D_S.'Shortcut'.D_S.LANG_NAME.'.php';
		if(is_file($_t_file)) {
			$_SL = include_cache($_t_file);
		}
		$this->assign('_SL', $_SL);
		/* Controller List */
		$_CL = get_ctrlrList(dirname(__FILE__));
		$this->assign('_CL', $_CL);

		/* Content Stat */
		$_CS = array();
		$_CS['article']['all'] = M('Article')->get_articleCount();
		$_CS['article']['not_passed'] = M('Article')->get_articleCount(array('a_status' => array('EQ', 0)));
		$_CS['article_review']['all'] = M('ArticleReview')->get_reviewCount();
		$_CS['article_review']['not_passed'] = M('ArticleReview')->get_reviewCount(array('ar_status' => array('EQ', 0)));
		$_CS['flink']['all'] = M('Flink')->get_flinkCount();
		$_CS['flink']['not_passed'] = M('Flink')->get_flinkCount(array('f_status' => array('EQ', 0)));
		$_CS['guestbook']['all'] = M('Guestbook')->count();
		$_CS['guestbook']['not_passed'] = M('Guestbook')->where(array('g_status' => array('EQ', 0)))->count();
		$_CS['single_page']['all'] = M('SinglePage')->get_singlePageCount();

		$this->assign('_CS', $_CS);

		/* Latest Admin Log */
		$_LMLL = M('Log')->get_logList(array('lang' => array('EQ', LANG_NAME)), '`l_time` DESC', 5);
		$this->assign('_LMLL', $_LMLL);

		$this->display('show_dashboard');
	}

	public function manage_shortcut_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$_t_file = CFG_PATH.D_S.'shortcut'.D_S.LANG_NAME.'.php';
		$_SL = ARequest::get('shortcut_set');
		$_SL = array_values($_SL);

		$result = file_put_contents($_t_file, "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($_SL, true).";\r\n?>");
		if(!$result) {
			M('Log')->add_log(L('MANAGE_SHORTCUT'), 0);
			$this->error(L('EDIT_FAILED'), Url::U('index/show_dashboard'));
		}

		M('Log')->add_log(L('MANAGE_SHORTCUT'));
		$this->success(L('EDIT_SUCCESS'), Url::U('index/show_dashboard'));
	}

	public function show_system_info() {
		/* System Environment */
		$_SE['os'] = PHP_OS;
		$_SE['server_software'] = AServer::get_env('SERVER_SOFTWARE');
		$mysqlInfo = M()->query('SELECT VERSION() AS version;');
		$_SE['mysql_version'] = $mysqlInfo[0]['version'];
		$_SE['php_version'] = @phpversion();
		$gdInfo = function_exists('gd_info') ? gd_info() : array('GD Version' => L('NONSUPPORT'));
		$_SE['gd_version'] = $gdInfo['GD Version'];
		$_SE['safe_mode'] = get_cfg_var('safe_mode') ? L('ON') : L('OFF');
		$_SE['register_globals'] = get_cfg_var('safe_register_globals') ? L('ON') : L('OFF');
		$_SE['magic_quoter_gpc'] = get_cfg_var('magic_quotes_gpc') ? L('ON') : L('OFF');
		$_SE['allow_url_fopen'] = get_cfg_var('allow_url_fopen') ? L('SUPPORT') : L('NONSUPPORT');
		$_SE['upload_max_size'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : L('UNKNOWN');
		$this->assign('_SE', $_SE);

		$this->display('show_system_info');
	}

	public function upload_licence_file_do() {
		if(!check_token()) {
			$this->error(L('DATA_INVALID'), AServer::get_preUrl());
		}

		$tmpName = $_FILES['licence_file']['tmp_name'];
		if(!is_uploaded_file($tmpName)) {
			$this->error(L('NOTHING_UPLOAD'), Url::U('index/show_system_info'));
		}
		elseif(1024*4 < $_FILES['licence_file']['size']) {
			// licence file should smaller than 4k
			$this->error(L('LICENCE_FILE_INVALID'), Url::U('index/show_system_info'));
		}

		$_licenceFile = DATA_PATH.D_S.'_licence.tmp';
		@move_uploaded_file($tmpName, $_licenceFile);
		$licence = file_get_contents($_licenceFile);
		@unlink($_licenceFile);
		$licenceFile = CFG_PATH.D_S.substr(md5(UUID.'|'.strtolower(AServer::get_env('HTTP_HOST'))), 0, 16).'.cer';

		$result = file_put_contents($licenceFile, $licence);
		if(!$result) {
			M('Log')->add_log(L('UPLOAD_LICENCE_FILE_FAILED'), 0);
			$this->error(L('UPLOAD_LICENCE_FILE_FAILED'), Url::U('index/show_system_info'));
		}

		if(!function_exists('get_licence') or !get_licence()) {
			@unlink($licenceFile);
			M('Log')->add_log(L('LICENCE_FILE_INVALID'), 0);
			$this->error(L('LICENCE_FILE_INVALID'), Url::U('index/show_system_info'));
		}

		M('Log')->add_log(L('UPLOAD_LICENCE_FILE_SUCCESS'));
		$this->success(L('UPLOAD_LICENCE_FILE_SUCCESS'), Url::U('index/show_system_info'));
	}

	/* check new version */
	public function _check_new_version() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		vendor('Snoopy#class');
		$s = get_instance('Snoopy');
		$s->agent = $_SERVER['HTTP_USER_AGENT'];
		$s->rawheaders['X_FORWARDED_FOR'] = CLIENT_IP;
		$s->expandlinks = true;
		$s->read_timeout = 18;

		$type = ARequest::get('type') ? ARequest::get('type') : 'manual';

		$latestCheckTime = F('_latest_version_check_time', '', RUNTIME_PATH);
		if('system' == $type) {
			if((NOW_TIME > $latestCheckTime + 86400 * 7) or NOW_TIME < $latestCheckTime) {
				$_l = function_exists('get_licence') ? get_licence() : null;
				if(is_array($_l)) {
					define(SOFT_AUTHORIZATION_VALIDATE_URL, 'http://ac.as'.'this.net/api/validate.php');
					$_l['soft'] = SOFT_NAME;
					$_l['soft_codename'] = SOFT_CODENAME;
					$s->submit(SOFT_AUTHORIZATION_VALIDATE_URL, $_l);
					if(200 == $s->status and 'invalid' == $s->results) {
						@unlink(CFG_PATH.D_S.substr(md5(UUID.'|'.strtolower(AServer::get_env('HTTP_HOST'))), 0, 16).'.cer');
					}
				}
				F('_latest_version_check_time', NOW_TIME, RUNTIME_PATH);
			}
		}

		$data = 0;
		$info = '';
		if('manual' == $type or ('system' == $type and ((NOW_TIME > $latestCheckTime + 86400 * 7) or NOW_TIME < $latestCheckTime))) {
			$s->fetch(SOFT_UPGRADE_URL);
			if(200 == $s->status) {
				$data = 2;
				$pattern = '|(\d+\.\d+\.\d+)|';
				if(preg_match($pattern, $s->results, $result)) {
					$latestVersion = $result[0];
					if(1 == strnatcmp($latestVersion, SOFT_VERSION)) {
						$data = 1;
						$info = $latestVersion;
					}
				}
			}
		}

		$this->ajax_return(array('data' => $data, 'info' => $info));
	}
}

?>