<?php

/**
 *--------------------------------------
 * article
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-10
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleCtrlr extends IndexCtrlr {
	public function show_category() {
		$_o = M('Option')->get_option('core');
		$articleCategoryId = intval(ARequest::get('article_category_id'));

		$_ACI = M('ArticleCategory')->get_categoryInfo($articleCategoryId);
		if(empty($_ACI) or !$_ACI['ac_display_switch']) {
			halt('', true, true);
		}
		$this->assign('_V', $_ACI);

		/* define current category id */
		$this->assign('AC_ID', $articleCategoryId);
		$_GCAP = 'home@article/show_category?article_category_id='.$articleCategoryId;
		$this->assign('_GCAP', $_GCAP);
		$this->assign('gcap', gcap($_GCAP));

		/* current position */
		$this->assign('_CP', $_ACI['ac_position']);

		/* get paging and list */
		$pageSign = md5('AC|'.$articleCategoryId.'|'.intval($_GET[C('VAR.PAGE')]));
		$_PG = S('_PG'.$pageSign);
		$_L = S('_L'.$pageSign);
		if(empty($_L)) {
			$where = array();
			$where['__ARTICLE__.a_status'] = array('EQ', 1);
			$where['__ARTICLE__.article_category_id'] = array('IN', implode(',', $_ACI['ac_sub_id']));

			$rowsNum = M('Article')->get_articleCount($where);
			if(0 < $rowsNum) {
				$_var_l = C('URL.LANG_SUFFIX') ? '&'.C('VAR.LANG').'='.$_ACI['lang'] : '';
				$p = new APage($rowsNum, $_ACI['ac_page_size'], Url::U('article/show_category?article_category_id='.$articleCategoryId.'&'.C('VAR.PAGE').'=_page_'.$_var_l));
				$_PG = $p->get_paging();

				$_L = M('Article')->get_articleList($where, '`a_rank` DESC, `a_edit_time` DESC', $p->get_limit());
				S('_PG'.$pageSign, $_PG);
				S('_L'.$pageSign, $_L);
			}
		}
		$this->assign('_PG', $_PG);
		$this->assign('_L', $_L);

		if(IS_AJAX) {
			$this->display('home/ajax/'.$_ACI['ac_tpl']);
		}
		else {
			$this->display('home/'.$_ACI['ac_tpl']);
		}
	}

	public function show_article() {
		$articleId = intval(ARequest::get('article_id'));

		$pageSign = md5('A|'.$articleId);
		$_AI = S('_AI'.$pageSign);
		if(empty($_AI)) {
			$_AI = M('Article')->get_articleInfo($articleId, true);
			if(empty($_AI) or 1 != $_AI['a_status']) {
				halt('', true, true);
			}
			S('_AI'.$pageSign, $_AI);
		}

		/* jump url */
		if(!empty($_AI['a_url_jump'])) {
			M('Article')->field_inc('a_view_count', array('article_id' => array('EQ', $articleId)));
			redirect($_AI['a_url_jump']);
		}

		/* define current category id */
		$this->assign('AC_ID', $_AI['article_category_id']);
		/* define current article id */
		$this->assign('A_ID', $_AI['article_id']);
		$this->assign('_GCAP', 'home@article/show_category?article_category_id='.$_AI['article_category_id']);
		$this->assign('gcap', gcap('home@article/show_article?article_id='.$_AI['article_id']));

		/* category information */
		$_ACI = M('ArticleCategory')->get_categoryInfo($_AI['article_category_id']);
		if(empty($_ACI)) {
			halt('', true, true);
		}
		$_AI['ac_tree'] = $_ACI['ac_tree'];

		/* current position */
		$_ACI['ac_position'][] = array('name' => $_AI['a_title'], 'url' => '');
		$this->assign('_CP', $_ACI['ac_position']);

		if(false !== strpos($_AI['a_content'], '<hr class="logapager" />')) {
			$_content = explode('<hr class="logapager" />', $_AI['a_content']);
			if('' == trim($_content[0])) {
				unset($_content[0]);
				$_content = array_values($_content);
			}

			$_var_l = C('URL.LANG_SUFFIX') ? '&'.C('VAR.LANG').'='.$_AI['lang'] : '';

			/* sub paging */
			$rowsNum = count($_content);
			$p = new APage($rowsNum, 1, Url::U('article/show_article?article_id='.$articleId.'&'.C('VAR.PAGE').'=_page_'.$_var_l));
			$this->assign('_PG', $p->get_paging());

			$_AI['a_content'] = $_content[$_GET[C('VAR.PAGE')] - 1];
			$_AI['a_sub_title'] = L('PAGER_OF_NUM', null, array('page' => $_GET[C('VAR.PAGE')]));
		}
		else {
			$this->assign('_PG', '');
			if(isset($_GET[C('VAR.PAGE')])) {
				halt('', true, true);
			}
		}

		$this->assign('_V', $_AI);

		if(IS_AJAX) {
			$this->display('home/ajax/'.$_AI['a_tpl']);
		}
		else {
			$this->display('home/'.$_AI['a_tpl']);
		}
	}

	/* get count */
	public function _get_count() {
		C('DEBUG.STAT', false);
		C('DEBUG.PAGE_TRACE', false);

		$articleId = intval(ARequest::get('article_id'));
		$type = ARequest::get('type');

		if('do_support' == $type) {
			if(!I('feedback_short', 1)) {
				$this->ajax_return(array('data' => 0, 'info' => L('_TRY_LATER_')));
			}
			M('Article')->field_inc('a_support_count', array('article_id' => array('EQ', $articleId)));
			I('feedback_short');
			$this->ajax_return(array('data' => 1, 'info' => L('SUPPORT_SUCCESS')));
		}
		elseif('do_oppose' == $type) {
			if(!I('feedback_short', 1)) {
				$this->ajax_return(array('data' => 0, 'info' => L('_TRY_LATER_')));
			}
			M('Article')->field_inc('a_oppose_count', array('article_id' => array('EQ', $articleId)));
			I('feedback_short');
			$this->ajax_return(array('data' => 1, 'info' => L('OPPOSE_SUCCESS')));
		}
		elseif('view' == $type) {
			M('Article')->field_inc('a_view_count', array('article_id' => array('EQ', $articleId)));
			$count = M('Article')->field('`a_view_count` AS `view`,`a_review_count` AS `review`,`a_support_count` AS `support`,`a_oppose_count` AS `oppose`')->where(array('article_id' => array('EQ', $articleId)))->select();
			if(empty($count)) {
				$this->ajax_return(array('data' => 0, 'info' => ''));
			}
			$this->ajax_return(array('data' => 1, 'info' => $count[0]));
		}
	}
}

?>