<?php

/**
 *--------------------------------------
 * home index
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-06-25
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class IndexCtrlr extends Ctrlr {
	public function __construct() {
		parent::__construct();

		if(!file_exists(CFG_PATH.D_S.'install.lock.php')) {
			redirect(__APP__.'install/');
		}

		$this->assign('_SITE',get_varSite());
		$this->assign('_G', get_varG());

		$timeKey = NOW_TIME;
		$_TK = array('timeKey' => $timeKey, 'token' => substr(md5(UUID.AServer::get_clientId().$timeKey), 8, 8));
		$this->assign('_TK', $_TK);

		$this->assign('TASK', '');
		$this->assign('_GCAP', GCAP);
		$this->assign('gcap', gcap(GCAP));

		$this->assign('_LS', get_langset());
		$this->assign('_PS', get_platformset());

		/* ban IP */
		if(M('BanIp')->is_banIp()) {
			halt(L('IP_LIMIT'), true, true);
		}
		cc_protect();
	}

	public function index() {
		$_oi = M('Option')->get_option('index');
		$this->assign('_GCAP', 'home@index/index');

		/* allow index paging */
		if($_oi['paging_switch']) {
			/* get paging */
			$_GET[C('VAR.PAGE')] = intval(ARequest::get(C('VAR.PAGE'))) ? intval(ARequest::get(C('VAR.PAGE'))) : 1;

			/* get paging and list */
			$pageSign = md5('I|'.intval($_GET[C('VAR.PAGE')]));
			$_PG = S('_PG'.$pageSign);
			$_L = S('_L'.$pageSign);
			if(empty($_L)) {
				$where = array();
				$where['__ARTICLE__.a_status'] = array('EQ', 1);
				$rowsNum = M('Article')->get_articleCount($where);
				if(0 < $rowsNum) {
					$p = new APage($rowsNum, $_oi['page_size'], Url::U('index/index?'.C('VAR.PAGE').'=_page_'));
					$_PG = $p->get_paging();
		
					$_L = M('Article')->get_articleList($where, '`a_rank` DESC, `a_edit_time` DESC', $p->get_limit());
					S('_PG'.$pageSign, $_PG);
					S('_L'.$pageSign, $_L);
				}
			}
			$this->assign('_PG', $_PG);
			$this->assign('_L', $_L);

			if(IS_AJAX) {
				$this->display('home/ajax/'.$_oi['tpl_paging']);
			}
			else {
				$this->display('home/'.$_oi['tpl_paging']);
			}
		}
		else {
			if(IS_AJAX) {
				$this->display('home/ajax/'.$_oi['tpl']);
			}
			else {
				$this->display('home/'.$_oi['tpl']);
			}
		}
	}
}

?>