<?php

/**
 *--------------------------------------
 * article review
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class ArticleReviewModl extends Modl {
	public function get_reviewCount($where = array()) {
		$where['ac.lang'] = array('EQ', LANG_NAME);

		$_count = $this->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->count();

		return $_count;
	}

	public function get_reviewList($where = array(), $order = '`ar_add_time` DESC', $limit = 5, $filter = true) {
		$where['ac.lang'] = array('EQ', LANG_NAME);

		$_ARL = $this->field('__ARTICLE_REVIEW__.*, a.a_title')
			->join('__ARTICLE__ as a ON a.article_id = __ARTICLE_REVIEW__.article_id')
			->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->order($order)->limit($limit)->select();

		if(!empty($_ARL)) {
			foreach($_ARL as $k => $v) {
				/* deal with emoji */
				if('>' == substr($v['ar_author'], 0, 1)) {
					$_ARL[$k]['ar_author'] = base64_decode(substr($v['ar_author'], 1));
				}
				if('>' == substr($v['ar_content'], 0, 1)) {
					$_ARL[$k]['ar_content'] = base64_decode(substr($v['ar_content'], 1));
				}
				if('>' == substr($v['ar_qoute'], 0, 1)) {
					$_ARL[$k]['ar_qoute'] = base64_decode(substr($v['ar_qoute'], 1));
				}

				if($filter and 2 == $v['ar_status']) {
					$_ARL[$k]['ar_author'] = M('Report')->filter_content($_ARL[$k]['ar_author']);
					$_ARL[$k]['ar_content'] = M('Report')->filter_content($_ARL[$k]['ar_content']);
					$_ARL[$k]['ar_qoute'] = M('Report')->filter_content($_ARL[$k]['ar_qoute']);
				}
				$_ARL[$k]['a_url'] = Url::U('home@article/show_article?article_id='.$v['article_id']);
			}
		}
		return $_ARL;
	}

	public function get_reviewInfo($articleReviewId, $parseBR = false) {
		$where = array();
		$where['article_review_id'] = array('EQ', $articleReviewId);
		$where['ac.lang'] = array('EQ', LANG_NAME);


		$_ARI = $this
			->join('__ARTICLE__ as a ON a.article_id = __ARTICLE_REVIEW__.article_id')
			->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->find();

		if(!empty($_ARI)) {
			/* deal with emoji */
			if('>' == substr($_ARI['ar_author'], 0, 1)) {
				$_ARI['ar_author'] = base64_decode(substr($_ARI['ar_author'], 1));
			}
			if('>' == substr($_ARI['ar_content'], 0, 1)) {
				$_ARI['ar_content'] = base64_decode(substr($_ARI['ar_content'], 1));
			}
			if('>' == substr($_ARI['ar_qoute'], 0, 1)) {
				$_ARI['ar_qoute'] = base64_decode(substr($_ARI['ar_qoute'], 1));
			}

			if($parseBR) {
				$_ARI['ar_content'] = str_replace("<br />", "\r\n", $_ARI['ar_content']);
				$_ARI['ar_qoute'] = str_replace("<br />", "\r\n", $_ARI['ar_qoute']);
			}
		}

		return $_ARI;
	}

	public function add_review($data) {
		$result = array('data' => '', 'error' => '');

		/* deal with emoji */
		if(1 == EO('article_review/emoji_switch')) {
			if(isset($data['ar_author'])) {
				$data['ar_author'] = '>'.base64_encode($data['ar_author']);
			}
			if(isset($data['ar_content'])) {
				$data['ar_content'] = '>'.base64_encode($data['ar_content']);
			}
			if(isset($data['ar_qoute'])) {
				$data['ar_qoute'] = '>'.base64_encode($data['ar_qoute']);
			}
		}

		unset($data['article_review_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		/* update article review count */
		if(1 == $data['ar_status']) {
			M('Article')->field_inc('a_review_count', array('article_id' => array('EQ', $data['article_id'])));
			M('ArticleCategory')->step_reviewCount($data['article_category_id']);
		}

		return $result;
	}

	public function edit_review($data) {
		$result = array('data' => '', 'error' => '');

		$where = array();
		$where['article_review_id'] = array('EQ', $data['article_review_id']);
		$where['ac.lang'] = array('EQ', LANG_NAME);

		$_ARI = M('ArticleReview')->field('ac.article_category_id,article_id,ar_status')
			->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->find();
		if(empty($_ARI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		/* deal with emoji */
		if(1 == EO('article_review/emoji_switch')) {
			if(isset($data['ar_author'])) {
				$data['ar_author'] = '>'.base64_encode($data['ar_author']);
			}
			if(isset($data['ar_content'])) {
				$data['ar_content'] = '>'.base64_encode($data['ar_content']);
			}
			if(isset($data['ar_qoute'])) {
				$data['ar_qoute'] = '>'.base64_encode($data['ar_qoute']);
			}
		}

		if(false === $this->update($data)) {
			$result['error'] = L('UPDATE_FAILED');
			return $result;
		}

		if(1 != $_ARI['ar_status']) {
			if(1 == $data['ar_status']) {
				M('Article')->field_inc('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
				M('ArticleCategory')->step_reviewCount($data['article_category_id']);
				if($data['article_category_id'] != $_ARI['article_category_id']) {
					M('ArticleCategory')->step_reviewCount($_ARI['article_category_id'], false);
				}
			}
		}
		else {
			if(1 != $data['ar_status']) {
				M('Article')->field_dec('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
				M('ArticleCategory')->step_reviewCount($_ARI['article_category_id'], false);
			}
			else {
				if($data['article_category_id'] != $_ARI['article_category_id']) {
					M('ArticleCategory')->step_reviewCount($data['article_category_id']);
					M('ArticleCategory')->step_reviewCount($_ARI['article_category_id'], false);
				}
			}
		}

		return $result;
	}

	public function delete_review($articleReviewId) {
		$result = array('data' => '', 'error' => '');

		$where = array();
		$where['article_review_id'] = array('EQ', $articleReviewId);
		$where['ac.lang'] = array('EQ', LANG_NAME);

		$_ARI = M('ArticleReview')->field('ac.article_category_id,article_id,ar_status')
			->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->find();
		if(empty($_ARI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->delete($articleReviewId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		if(1 == $_ARI['ar_status']) {
			M('Article')->field_dec('a_review_count', array('article_id' => array('EQ', $_ARI['article_id'])));
			M('ArticleCategory')->step_reviewCount($articleReviewId, false);
		}

		return $result;
	}

	public function delete_sameIp($articleReviewId) {
		$result = array('data' => '', 'error' => '');

		$where = array();
		$where['article_review_id'] = array('EQ', $articleReviewId);
		$where['ac.lang'] = array('EQ', LANG_NAME);

		$_ARI = $this->field('ar_add_ip')
			->join('__ARTICLE_CATEGORY__ AS ac ON ac.article_category_id = __ARTICLE_REVIEW__.article_category_id')
			->where($where)->find();
		if(empty($_ARI)) {
			return $result;
		}

		if(false === $this->where(array('ar_add_ip' => array('EQ', $_ARI['ar_add_ip'])))->delete()) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}
}

?>