<?php

/**
 *--------------------------------------
 * file explore
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2017-03-30
 * @copyright	: (c)2017 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class FileExploreModl extends Modl {
	protected $_o;

	public function __construct() {
		parent::__construct();

		$this->_o = M('Option')->get_option('upload');
	}

	/* get file list */
	public function get_fileList($currentDir) {
		$baseDir = ROOT_PATH.D_S.$this->_o['dir'];
		$currentPath = $baseDir.$currentDir;

		$_FL['parent_dir'] = str_replace(array(D_S, '.'), array('*', '@'), dirname($currentDir));
		$_FL['current_dir'] = str_replace(array(D_S, '.'), array('*', '@'), $currentDir);

		if(is_dir($currentPath)) {
			$dh = dir($currentPath);
			while(false !== ($fs = $dh->read())) {
				if('.' == $fs or '..' == $fs or '.svn' == $fs or '_names.php' == $fs or 'index.html' == $fs or '_descriptions_' == substr($fs, 0, strlen('_descriptions_'))) {
					continue;
				}

				if(is_dir($currentPath.D_S.$fs)) {
					$dir['name'] = str_replace(array(D_S, '.'), array('*', '@'), $fs);
					$_FL['list']['dir'][] = $dir;
				}
				else {
					$file['name'] = AString::auto_charset($fs);
					$file['url'] = __ROOT__.$this->_o['dir'].str_replace('\\', '/', $currentDir).'/'.$fs;
					$file['type'] = get_fileType($fs);
					$file['size'] = byte_format(filesize($currentPath.D_S.$fs));
					$file['edit_time'] = date(C('APP.TIME_FORMAT'), filemtime($currentPath.D_S.$fs));
					$_FL['list']['file'][] = $file;
				}
			}
		}
		return $_FL;
	}

	/* delete directory */
	public function delete_dir($dir, $dirname) {
		$result = array('data' => '', 'error' => '');

		$diretory = ROOT_PATH.D_S.$this->_o['dir'].str_replace(array('*', '@'), array(D_S, '.'), $dir).D_S.$dirname;

		if(!is_dir($diretory)) {
			$result['error'] = 'FILE['.$dir.'*'.$dirname.']'.L('INEXISTENCE');
			return $result;
		}
		if(!clear_dir($diretory, true, array(), true)) {
			$result['error'] = 'FILE['.$dir.'*'.$dirname.']'.L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}

	/* delete file */
	public function delete_file($dir, $file) {
		$result = array('data' => '', 'error' => '');

		$file = ROOT_PATH.D_S.$this->_o['dir'].str_replace(array('*', '@'), array(D_S, '.'), $dir).D_S.$file;

		if(!is_file($file)) {
			$result['error'] = 'FILE['.$dir.'*'.$file.']'.L('INEXISTENCE');
			return $result;
		}
		if(!@unlink($file)) {
			$result['error'] = 'FILE['.$dir.'*'.$file.']'.L('DELETE_FAILED');
			return $result;
		}

		return $result;
	}

	public function add_dir($dir, $dirname) {
		$result = array('data' => '', 'error' => '');

		$diretory = ROOT_PATH.D_S.$this->_o['dir'].str_replace(array('*', '@'), array(D_S, '.'), $dir).D_S.$dirname;

		if(is_dir($diretory)) {
			$result['error'] = 'FILE['.$dir.'*'.$dirname.']'.L('EXIST');
			return $result;
		}

		if(!mk_dir($diretory)) {
			$result['error'] = L('DIR_MAKE_FAILED', null, array('dirname' => $dir.'*'.$dirname));
			return $result;
		}

		return $result;
	}

	/* check the dir string */
	public static function check_dirStr($dir) {
		if(false !== strpos($dir, '.') or false !== strpos($dir, '/') or '' != strstr($dir, '@@*')) {
			return false;
		}
		return true;
	}

	/* check the filename */
	public static function check_filename($filename) {
		if(false !== strpos($filename, '/') or false !== strpos($filename, '*')) {
			return false;
		}
		return true;
	}

}

?>