<?php

/**
 *--------------------------------------
 * option
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2012-10-15
 * @copyright	: (c)2012 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class OptionModl extends Modl {
	/* get system option. $key: site, site/name, array('site', 'core') */
	public function get_option($key = null) {
		$option = F('__O');
		if(empty($option)) {
			$option = array();
			$_O = $this->select();
			foreach($_O as $k => $v) {
				$v['o_value'] = unserialize($v['o_value']);
				if(MAGIC_QUOTES_GPC) {
					$v['o_value'] = stripslashes_array($v['o_value']);
				}
				$option[$v['o_key']] = $v['o_value'];
			}
			F('__O', $option);
		}

		if(is_string($key)) {
			$key = explode('/', $key);
			foreach($key as $key) {
				$option = isset($option[$key]) ? $option[$key] : null;
			}
		}
		elseif(is_array($key)) {
			$_O = array();
			foreach($key as $key) {
				$_O[$key] = isset($option[$key]) ? $option[$key] : null;
			}
			$option = $_O;
		}
		return $option;
	}

	/* save */
	public function save_option($option) {
		if(is_array($option)) {
			foreach($option as $k => $v) {
				$where = array();
				$where['o_key'] = array('EQ', $k);
				$v = serialize($v);
				if(MAGIC_QUOTES_GPC) {
					$v = addslashes($v);
				}
				$this->where($where)->set_field('o_value', $v);
			}
			F('__O', null);
			return true;
		}
		return false;
	}

	/* save config file, $replace: array('a.b' => array(1, 2), 'a.c' => '') */
	public function save_configFile($config, $replace = array()) {
		$result = array('data' => '', 'error' => '');

		$cfgFile = CFG_PATH.D_S.'comm.php';
		$config = marray_merge(include($cfgFile), $config);
		if(!empty($replace)) {
			foreach($replace as $key => $val) {
				if(strpos($key, '.')) {
					$k = explode('.', $key);
					$config[$k[0]][$k[1]] = $val;
				}
				else {
					$config[$key] = $val;
				}
			}
		}
		$content = "<?php\r\n".PFA_ACCESS_CHECK."return ".var_export($config, true).";\r\n?>";
		if(!@file_put_contents($cfgFile, $content)) {
			$result['error'] = L('SAVE_CFG_FILE_FAILED');
			return $result;
		}
		if(file_exists(RUNTIME_PATH.D_S.'_runtime.php')) {
			@unlink(realpath(RUNTIME_PATH.D_S.'_runtime.php'));
		}
		return $result;
	}

	public function get_customOptionList($lang = true) {
		$_CO = $this->order('`o_display_order` ASC,`o_key` ASC')->where(array('o_type' => array('NEQ', 'system')))->select();
		if(!empty($_CO)) {
			foreach($_CO as $k => $o) {
				$_CO[$k]['o_title'] = unserialize($o['o_title']);
				$_CO[$k]['o_description'] = unserialize($o['o_description']);
				$_CO[$k]['o_value'] = unserialize($o['o_value']);
				if(MAGIC_QUOTES_GPC) {
					$_CO[$k]['o_title'] = stripslashes_array($_CO[$k]['o_title']);
					$_CO[$k]['o_description'] = stripslashes_array($_CO[$k]['o_description']);
					$_CO[$k]['o_value'] = stripslashes_array($_CO[$k]['o_value']);
				}
				if($lang) {
					$_CO[$k]['o_title'] = get_itemL($_CO[$k]['o_title']);
					$_CO[$k]['o_description'] = get_itemL($_CO[$k]['o_description']);
				}
			}
		}
		return $_CO;
	}

	public function add_customOption($data) {
		$result = array('data' => '', 'error' => '');

		$_t_co = $this->where(array('o_key' => array('EQ', $data['o_key'])))->find();
		if(!empty($_t_co)) {
			$result['error'] = L('CUSTOM_OPTION_EXIST');
			return $result;
		}

		$data['o_title'] = serialize($data['o_title']);
		$data['o_description'] = serialize($data['o_description']);
		if(MAGIC_QUOTES_GPC) {
			$data['o_title'] = addslashes($data['o_title']);
			$data['o_description'] = addslashes($data['o_description']);
		}

		$data['o_display_order'] = 0;

		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $data['o_key'];

		F('__O', null);

		return $result;
	}

	public function delete_customOption($oKey) {
		$result = array('data' => '', 'error' => '');

		$oKey = ARequest::get('o_key');
		$_t_o = $this->where(array('o_type' => array('NEQ', 'system'), 'o_key' => array('EQ', $oKey)))->find();
		if(empty($_t_o)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->where(array('o_type' => array('NEQ', 'system'), 'o_key' => array('EQ', $oKey)))->delete()) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		F('__O', null);

		return $result;
	}

	public function sort_customOption($sort) {
		$result = array('data' => '', 'error' => '');

		foreach($sort as $key => $order) {
			$where = array();
			$where['o_key'] = array('EQ', $key);
			if(false === $this->where($where)->set_field('o_display_order', $order)) {
				$result['error'] = L('SORT_FAILED');
				return $result;
			}
		}
		F('__O', null);

		return $result;
	}
}

?>