<?php

/**
 *--------------------------------------
 * single page
 *--------------------------------------
 * @project		: loga
 * @author		: cblee
 * @created		: 2016-07-07
 * @copyright	: (c)2016 AsThis
 *--------------------------------------
 */
defined('PFA_PATH') or exit('Access Denied');

class SinglePageModl extends Modl {
	public function get_singlePageCount($where = array(), $lang = LANG_NAME) {
		if(C('LANG.DETECT')) {
			$where['lang'] = array(array('EQ', $lang), array('EQ', '_m'), 'OR');
		}
		else {
			$where['lang'] = array('EQ', $lang);
		}
		return $this->where($where)->count();
	}

	public function get_singlePageList($spGroup = '', $spParentId = 'all', $limit = 500, $where = array()) {
		$where['lang'] = array('EQ', LANG_NAME);
		if(!empty($spGroup)) {
			$where['sp_group'] = array('EQ', $spGroup);
		}
		if('all' != $spParentId) {
			$where['sp_parent_id'] = array('EQ', $spParentId);
		}
		$field = 'sp_group,single_page_id,sp_parent_id,sp_display_order,sp_title,sp_keywords,sp_description,sp_edit_time,sp_is_html,sp_html_naming,sp_url,sp_url_o';
		$_SPL = $this->field($field)
			->where($where)->order('`sp_display_order` ASC, `single_page_id` ASC')->limit($limit)->select();
		if(!empty($_SPL)) {
			foreach($_SPL as $k => $v) {
				/* update url */
				if(empty($v['sp_url']) or empty($v['sp_url_o'])) {
					$_r = $this->build_url($v['single_page_id']);
					$_SPL[$k]['sp_url'] = $_r['sp_url'];
					$_SPL[$k]['sp_url_o'] = $_r['sp_url_o'];
				}
			}
		}
		return $_SPL;
	}

	public function get_singlePageInfo($singlePageId) {
		$where = array();
		$where['single_page_id'] = array('EQ', $singlePageId);
		$where['lang'] = array('EQ', LANG_NAME);

		$_SPI = $this->where($where)->find();
		if(!empty($_SPI)) {
			/* update url */
			if(empty($_SPI['sp_url']) or empty($_SPI['sp_url_o'])) {
				$_r = $this->build_url($_SPI['single_page_id']);
				$_SPI['sp_url'] = $_r['sp_url'];
				$_SPI['sp_url_o'] = $_r['sp_url_o'];
			}

			/* get position */
			$_SPL = $this->get_singlePageList($_SPI['sp_group']);
			$spt = new ATree($_SPL, array('single_page_id', 'sp_parent_id', 'sp_sub_page'));
			$_SPI['sp_tree'] = $spt->get_leaf(0);

			$navi = $spt->get_navi($singlePageId);
			$_SPI['sp_position'] = array();
			$_SPI['sp_position'][] = array('name' => L('HOME'), 'url' => Url::U('home@index/index'));
			$_SPI['sp_position_o'] = array();
			$_SPI['sp_position_o'][] = array('name' => L('HOME'), 'url' => Url::U('home@index/index'));
			foreach($navi as $k => $v) {
				$_SPI['sp_position'][] = array('name' => $v['sp_title'], 'url' => $v['sp_url']);
				$_SPI['sp_position_o'][] = array('name' => $v['sp_title'], 'url' => $v['sp_url_o']);
			}
		}
		return $_SPI;
	}

	public function add_singlePage($data) {
		$result = array('data' => '', 'error' => '');

		$data['lang'] = LANG_NAME;
		unset($data['single_page_id']);
		$_t_id = $this->insert($data);
		if(false === $_t_id) {
			$result['error'] = L('ADD_FAILED');
			return $result;
		}
		$result['data'] = $_t_id;

		return $result;
	}

	public function edit_singlePage($data) {
		$result = array('data' => '', 'error' => '');

		unset($data['lang']);
		if(false === $this->update($data)) {
			$result['error'] = L('EDIT_FAILED');
			return $result;
		}

		return $result;
	}

	public function delete_singlePage($singlePageId) {
		$result = array('data' => '', 'error' => '');

		$_SPI = $this->get_singlePageInfo($singlePageId);
		if(empty($_SPI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		if(false === $this->delete($singlePageId)) {
			$result['error'] = L('DELETE_FAILED');
			return $result;
		}

		/* delete html file */
		if($_SPI['sp_is_html']) {
			$rootUrl = C('LANG.DETECT') ? $_SPI['lang'].'/' : '';
			$naming = str_replace(
				array('{root_url}'),
				array($rootUrl),
				$_SPI['sp_html_naming']
			);
			@unlink(realpath(ROOT_PATH.'/'.trim($naming, '/').C('URL.FILE_SUFFIX')));
		}

		return $result;
	}

	public function build_url($singlePageId) {
		$result = array('data' => '', 'error' => '');

		$_SPI = $this->where(array('single_page_id' => array('EQ', $singlePageId)))->find();
		if(empty($_SPI)) {
			$result['error'] = L('ITEM_INEXISTENCE');
			return $result;
		}

		$_var_l = C('URL.LANG_SUFFIX') ? '&'.C('VAR.LANG').'='.$_SPI['lang'] : '';
		$url_o = Url::U('home@single_page/show_single_page?single_page_id='.$singlePageId.$_var_l);

		if($_SPI['sp_is_html']) {
			$rootUrl = C('LANG.DETECT') ? $_SPI['lang'].'/' : '';
			$naming = str_replace(
				array('{root_url}'),
				array($rootUrl),
				$_SPI['sp_html_naming']
			);
			$url = __APP__.trim($naming, '/').C('URL.FILE_SUFFIX');
		}
		else {
			$url = $url_o;
		}
		$this->where(array('single_page_id' => array('EQ', $singlePageId)))->set_field(array('sp_url', 'sp_url_o'), array($url, $url_o));
		$result['sp_url'] = $url;
		$result['sp_url_o'] = $url_o;
		return $result;
	}

	/* get single page select */
	public function get_singlePageSelect($_SPL, $singlePageId = 0, $selectType = 'current', $exclude = array()) {
		$singlePageSelect = array();

		$singlePage = new ATree($_SPL, array('single_page_id', 'sp_parent_id', 'sp_sub_page'));

		if('current' == $selectType) {
			/* get sub page when single page id is zero */
			$spNav = $singlePage->get_navi($singlePageId);
			if(0 == $singlePageId) {
				$spNav = $singlePage->get_leaf($singlePageId);
				$_t_s = array();
				if(!empty($spNav)) {
					foreach($spNav as $spn) {
						if(!empty($exclude) and in_array($spn['single_page_id'], $exclude)) {
							continue;
						}
						$_t_s[] = array(
							'id' => $spn['single_page_id'],
							'name' => $spn['sp_title']
						);
					}
				}
				$singlePageSelect[] = $_t_s;
			}
			else {
				foreach($spNav as $spn) {
					if(!empty($exclude) and in_array($spn['sp_parent_id'], $exclude)) {
						break;
					}
					$_t_s = array();
					/* current single page list */
					$_CSPL = $singlePage->get_leaf($spn['sp_parent_id']);
					foreach($_CSPL as $k => $sp) {
						if(!empty($exclude) and in_array($sp['single_page_id'], $exclude)) {
							continue;
						}
						if(($singlePageId == $sp['single_page_id'])
							or ((0 != $singlePageId) and ($spn['single_page_id'] == $sp['single_page_id']))) {
							$_t_s[] = array(
								'id' => $sp['single_page_id'],
								'name' => $sp['sp_title'],
								'selected' => true
							);
						}
						else {
							$_t_s[] = array(
								'id' => $sp['single_page_id'],
								'name' => $sp['sp_title']
							);
						}
					}
					$singlePageSelect[] = $_t_s;
				}
			}
		}
		elseif('sub' == $selectType) {
			if(!empty($singlePageId)) {
				$spNav = $singlePage->get_leaf($singlePageId);
				if(!empty($spNav)) {
					$_t_s = array();
					foreach($spNav as $spn) {
						if(!empty($exclude) and in_array($spn['single_page_id'], $exclude)) {
							continue;
						}
						$_t_s[] = array(
							'id' => $spn['single_page_id'],
							'name' => $spn['sp_title']
						);
					}
					$singlePageSelect[] = $_t_s;
				}
			}
		}

		return $singlePageSelect;
	}

}

?>