<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common.css" />
{-if:'rtl'==_LD_-}
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}fea/css/fea.g.rtl.min.css" />
<link rel="stylesheet" type="text/css" href="{-:*__RES__-}css/calendar-rtl.css" />
<link rel="stylesheet" type="text/css" href="{-:*__STYLE__-}css/common-rtl.css" />
{-:/if-}
<script src="{-:*__RES__-}js/calendar/calendar.js"></script>
<script src="{-:*__RES__-}js/calendar/lang/{-:*LANG_NAME-}.js"></script>
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	}
};
</script>
</head>

<body>
<div class="container margin">

<form id="formAdd" action="" method="post">
<ul class="subnav subnav-tab">
	<li class="active"><a href="#">{-:@ADD_AD-}</a></li>
</ul>
<div id="tabContent">
	<table class="formTable margin">
		<tr>
			<td class="inputTitle">{-:@AD_SPACE-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				{-:$_ASI['as_name']-}
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> {-:@AD_SPACE_TIP-}
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@TYPE-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				{-if:'code' == $_ASI['as_type']-}{-:@CODE-}{-:/if-}
				{-if:'text' == $_ASI['as_type']-}{-:@TEXT-}{-:/if-}
				{-if:'image' == $_ASI['as_type']-}{-:@IMAGE-}{-:/if-}
				{-if:'slide' == $_ASI['as_type']-}{-:@SLIDE-}{-:/if-}
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@AS_TYPE_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@NAME-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input type="text" name="a_name" validate="/\S+/" value="" class="control-input input-inline" maxlength="96" size="30">
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@AD_NAME_TIP-}</span>
			</td>
		</tr>
		<tr {-if:'code' == $_ASI['as_type'] or 'text' == $_ASI['as_type']-} style="display:none"{-:/if-}>
			<td colspan="2" class="inputArea">
				<strong>{-:@FILE-}</strong><br />
				<input id="a_file" class="control-input input-inline ltr" type="text" value="" name="a_file" maxlength="255" size="50">
				<span id="a_file_finder" to="#a_file" preview="#a_file_preview" class="btn finder">{-:@BROWSE_SERVER-}</span>
			</td>
		</tr>
		<tr id="a_content">
			<td colspan="2" class="inputArea">
				<strong>{-:@CONTENT-}</strong> <span class="text-muted">{-:@AD_CONTENT_TIP-}</span><br />
				<textarea class="control-input {-if:'code' != $_ASI['as_type']-}editor{-:/if-}" name="a_content" style="width:480px;height:105px;"></textarea>
			</td>
		</tr>
		{-if:'code' != $_AI['as_type']-}<tr>
			<td class="inputTitle">{-:@LINK-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input id="a_link" type="text" name="a_link" validate="/\S+/" value="#" class="control-input input-inline" maxlength="96" size="50">
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@AD_LINK_TIP-}</span>
			</td>
		</tr>{-:/if-}
		<tr>
			<td class="inputTitle">{-:@TIME_LIMIT-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<label><input type="radio" value="0" name="a_time_limit" checked="checked"> {-:@NOT_LIMIT-}</label>
				<label><input type="radio" value="1" name="a_time_limit"> {-:@VALIDITY_PERIOD-}</label>
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@AD_TIME_LIMIT_TIP-}</span>
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@VALIDITY_PERIOD-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input class="control-input input-inline calendar" type="text" value="{-php:echo date(C('APP.TIME_FORMAT'));-}" format="{-:#APP.TIME_FORMAT-}" id="a_start_time" name="a_start_time" maxlength="20" size="20"> ~
				<input class="control-input input-inline calendar" type="text" value="{-php:echo date(C('APP.TIME_FORMAT'), NOW_TIME+86400*30);-}" format="{-:#APP.TIME_FORMAT-}" id="a_end_time" name="a_end_time" maxlength="20" size="20">
			</td>
			<td class="inputTip">
				{-:@AD_VALIDITY_PERIOD_TIP-}
			</td>
		</tr>
		<tr>
			<td class="inputTitle">{-:@DISPLAY_ORDER-}</td>
			<td></td>
		</tr>
		<tr>
			<td class="inputArea">
				<input type="text" name="a_display_order" validate="/\S+/" value="50" class="control-input input-inline" maxlength="20" size="10">
			</td>
			<td class="inputTip">
				<span class="text-danger">*</span> <span class="text-muted">{-:@AD_DISPLAY_ORDER_TIP-}</span>
			</td>
		</tr>
	</table>
</div>
<div id="operation" class="margin">
	<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
	<input name="token" type="hidden" value="{-:$_TK['token']-}">
	<input type="hidden" value="{-:$_ASI['as_alias']-}" name="as_alias">
	<span class="btn btn-info submit" action="{-url:admin@ad/add_ad_do-}" to="#formAdd">{-:@SUBMIT-}</span>
	<input class="btn" type="reset" value="{-:@RESET-}">
	<a class="btn" href="{-url:admin@ad/list_ad-}">{-:@BACK-}</a>
</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/calendar.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
</body>
</html>