<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@MANAGE-}</title>
{-include:../meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	EDITOR: {
		BASE_PATH: '{-:*__RES__-}js/editor/',
		PLUGIN_PATH: '{-:*__RES__-}js/editor/plugins/',
		UPLOAD_JSON: '{-url:editorjson/upload-}',
		FILE_MANAGER_JSON: '{-url:editorjson/file_manage-}',
		FORM_DATA : {
			'timeKey' : '{-:$_TK["timeKey"]-}',
			'token' : '{-:$_TK["token"]-}'
		}
	}
};
</script>
</head>

<body>
<div class="container margin">

<ul class="subnav subnav-tab">
	<li class="active"><a href="{-url:admin@option/edit_option_site-}">{-:@SITE-}</a></li>
	<li><a href="{-url:admin@option/edit_option_core-}">{-:@CORE-}</a></li>
	<li><a href="{-url:admin@option/edit_option_platform-}">{-:@PLATFORM-}</a></li>
	<li><a href="{-url:admin@option/edit_option_language-}">{-:@LANGUAGE-}</a></li>
	<li><a href="{-url:admin@option/edit_option_index-}">{-:@INDEX-}</a></li>
	<li><a href="{-url:admin@option/edit_option_upload-}">{-:@UPLOAD-}</a></li>
	<li><a href="{-url:admin@option/edit_option_image-}">{-:@IMAGE-}</a></li>
	<li><a href="{-url:admin@option/edit_option_interaction-}">{-:@INTERACTION-}</a></li>
	<li><a href="{-url:admin@option/edit_option_administrator-}">{-:@ADMINISTRATOR-}</a></li>
	<li><a href="{-url:admin@option/edit_custom_option-}">{-:@CUSTOM_OPTION-}</a></li>
</ul>

<form id="formEdit" class="form" action="" method="post">
	<div id="tabContent">
	{-if:C('LANG.DETECT')-}
		<ul class="subnav subnav-pill margin" data-switcher="{'connect':'#tabSite'}">
			<li><a href="#">{-:*LANG_NAME|get_langName-}</a></li>
		{-foreach:$_LS,$alias,$lang-}
			{-if:$alias!==LANG_NAME-}<li><a href="#">{-:$lang-}</a></li>{-:/if-}
		{-:/foreach-}
		</ul>
		<div id="tabSite" class="switcher margin">
			<table class="formTable">
				<tr>
					<td class="inputTitle">{-:@SITE_NAME-} <span class="badge">{-php:echo '{';-}-:$_SITE['name']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input type="text" name="site[{-:*LANG_NAME-}][name]" validate="/\S+/" value="{-:$_O['site'][LANG_NAME]['name']-}" class="control-input input-inline" maxlength="255" size="50">
					</td>
					<td class="inputTip">
						<span class="text-danger">*</span> {-:@SITE_NAME_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_LOGO-} <span class="badge">{-php:echo '{';-}-:$_SITE['logo']-}</span></td>
					<td rowspan="2" class="inputArea">
						<img id="site_{-:*LANG_NAME-}_logo_preview" src="{-:$_O['site'][LANG_NAME]['logo']-}" />
					</td>
				</tr>
				<tr>
					<td class="inputArea">
						<input id="site_{-:*LANG_NAME-}_logo" type="text" name="site[{-:*LANG_NAME-}][logo]" validate="/\S+/" value="{-:$_O['site'][LANG_NAME]['logo']-}" class="control-input input-inline" maxlength="255" size="30">
						<span id="site_{-:*LANG_NAME-}_logo_finder" to="#site_{-:*LANG_NAME-}_logo" preview="#site_{-:*LANG_NAME-}_logo_preview" class="btn finder">{-:@BROWSE_SERVER-}</span>
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_KEYWORDS-} <span class="badge">{-php:echo '{';-}-:$_SITE['keywords']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input" name="site[{-:*LANG_NAME-}][keywords]" style="width:480px;height:70px;">{-:$_O['site'][LANG_NAME]['keywords']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_KEYWORDS_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_DESCRIPTION-} <span class="badge">{-php:echo '{';-}-:$_SITE['description']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input" name="site[{-:*LANG_NAME-}][description]" style="width:480px;height:70px;">{-:$_O['site'][LANG_NAME]['description']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_DESCRIPTION_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_COPYRIGHT-} <span class="badge">{-php:echo '{';-}-:$_SITE['copyright']-}</span> <span class="text-normal text-muted">{-:@SITE_COPYRIGHT_TIP-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td colspan="2" class="inputArea">
						<textarea class="editor" name="site[{-:*LANG_NAME-}][copyright]">{-:$_O['site'][LANG_NAME]['copyright']|htmlspecialchars-}</textarea>
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_STAT_CODE-} <span class="badge">{-php:echo '{';-}-:$_SITE['stat_code']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input ltr" name="site[{-:*LANG_NAME-}][stat_code]" style="width:480px;height:105px;">{-:$_O['site'][LANG_NAME]['stat_code']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_STAT_CODE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_ADDON_META-} <span class="badge">{-php:echo '{';-}-:$_SITE['addon_meta']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input ltr" name="site[{-:*LANG_NAME-}][addon_meta]" style="width:480px;height:105px;">{-:$_O['site'][LANG_NAME]['addon_meta']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_ADDON_META_TIP-}
					</td>
				</tr>
			</table>
		{-foreach:$_LS,$alias,$lang-}
			{-if:$alias!==LANG_NAME-}
				<table class="formTable">
					<tr>
						<td class="inputTitle">{-:@SITE_NAME-} <span class="badge">{-php:echo '{';-}-:$_SITE['name']-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td class="inputArea">
							<input type="text" name="site[{-:$alias-}][name]" validate="/\S+/" value="{-:$_O['site'][$alias]['name']-}" class="control-input" maxlength="255" size="50">
						</td>
						<td class="inputTip">
							<span class="text-danger">*</span> {-:@SITE_NAME_TIP-}
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_LOGO-} <span class="badge">{-php:echo '{';-}-:$_SITE['logo']-}</span></td>
						<td rowspan="2" class="inputArea">
							<img id="site_{-:$alias-}_logo_preview" src="{-:$_O['site'][$alias]['logo']-}" />
						</td>
					</tr>
					<tr>
						<td class="inputArea">
							<input id="site_{-:$alias-}_logo" type="text" name="site[{-:$alias-}][logo]" validate="/\S+/" value="{-:$_O['site'][$alias]['logo']-}" class="control-input input-inline" maxlength="255" size="30">
							<span id="site_{-:$alias-}_logo_finder" to="#site_{-:$alias-}_logo" preview="#site_{-:$alias-}_logo_preview" class="btn finder">{-:@BROWSE_SERVER-}</span>
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_KEYWORDS-} <span class="badge">{-php:echo '{';-}-:$_SITE['keywords']-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td class="inputArea">
							<textarea class="control-input" name="site[{-:$alias-}][keywords]" style="width:480px;height:70px;">{-:$_O['site'][$alias]['keywords']-}</textarea>
						</td>
						<td class="inputTip">
							{-:@SITE_KEYWORDS_TIP-}
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_DESCRIPTION-} <span class="badge">{-php:echo '{';-}-:$_SITE['description']-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td class="inputArea">
							<textarea class="control-input" name="site[{-:$alias-}][description]" style="width:480px;height:70px;">{-:$_O['site'][$alias]['description']-}</textarea>
						</td>
						<td class="inputTip">
							{-:@SITE_DESCRIPTION_TIP-}
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_COPYRIGHT-} <span class="badge">{-php:echo '{';-}-:$_SITE['copyright']-}</span> <span class="text-normal text-muted">{-:@SITE_COPYRIGHT_TIP-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td colspan="2" class="inputArea">
							<textarea class="editor" name="site[{-:$alias-}][copyright]">{-:$_O['site'][$alias]['copyright']|htmlspecialchars-}</textarea>
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_STAT_CODE-} <span class="badge">{-php:echo '{';-}-:$_SITE['stat_code']-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td class="inputArea">
							<textarea class="control-input ltr" name="site[{-:$alias-}][stat_code]" style="width:480px;height:105px;">{-:$_O['site'][$alias]['stat_code']-}</textarea>
						</td>
						<td class="inputTip">
							{-:@SITE_STAT_CODE_TIP-}
						</td>
					</tr>
					<tr>
						<td class="inputTitle">{-:@SITE_ADDON_META-} <span class="badge">{-php:echo '{';-}-:$_SITE['addon_meta']-}</span></td>
						<td class=""></td>
					</tr>
					<tr>
						<td class="inputArea">
							<textarea class="control-input ltr" name="site[{-:$alias-}][addon_meta]" style="width:480px;height:105px;">{-:$_O['site'][$alias]['addon_meta']-}</textarea>
						</td>
						<td class="inputTip">
							{-:@SITE_ADDON_META_TIP-}
						</td>
					</tr>
				</table>
			{-:/if-}
		{-:/foreach-}
		</div>
	{-else:-}
			<table class="formTable margin">
				<tr>
					<td class="inputTitle">{-:@SITE_NAME-} <span class="badge">{-php:echo '{';-}-:$_SITE['name']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<input type="text" name="site[{-:*LANG_NAME-}][name]" validate="/\S+/" value="{-:$_O['site'][LANG_NAME]['name']-}" class="control-input input-inline" maxlength="255" size="50">
					</td>
					<td class="inputTip">
						<span class="text-danger">*</span> {-:@SITE_NAME_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_LOGO-} <span class="badge">{-php:echo '{';-}-:$_SITE['logo']-}</span></td>
					<td rowspan="2" class="inputArea">
						<img id="site_{-:*LANG_NAME-}_logo_preview" src="{-:$_O['site'][LANG_NAME]['logo']-}" />
					</td>
				</tr>
				<tr>
					<td class="inputArea">
						<input id="site_{-:*LANG_NAME-}_logo" type="text" name="site[{-:*LANG_NAME-}][logo]" validate="/\S+/" value="{-:$_O['site'][LANG_NAME]['logo']-}" class="control-input input-inline" maxlength="255" size="30">
						<span id="site_{-:*LANG_NAME-}_logo_finder" to="#site_{-:*LANG_NAME-}_logo" preview="#site_{-:*LANG_NAME-}_logo_preview" typeset='image' class="btn finder">{-:@BROWSE_SERVER-}</span>
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_KEYWORDS-} <span class="badge">{-php:echo '{';-}-:$_SITE['keywords']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input" name="site[{-:*LANG_NAME-}][keywords]" style="width:480px;height:70px;">{-:$_O['site'][LANG_NAME]['keywords']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_KEYWORDS_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_DESCRIPTION-} <span class="badge">{-php:echo '{';-}-:$_SITE['description']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input" name="site[{-:*LANG_NAME-}][description]" style="width:480px;height:70px;">{-:$_O['site'][LANG_NAME]['description']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_DESCRIPTION_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_COPYRIGHT-} <span class="badge">{-php:echo '{';-}-:$_SITE['copyright']-}</span> <span class="text-normal text-muted">{-:@SITE_COPYRIGHT_TIP-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td colspan="2" class="inputArea">
						<textarea class="editor" name="site[{-:*LANG_NAME-}][copyright]">{-:$_O['site'][LANG_NAME]['copyright']|htmlspecialchars-}</textarea>
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_STAT_CODE-} <span class="badge">{-php:echo '{';-}-:$_SITE['stat_code']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input ltr" name="site[{-:*LANG_NAME-}][stat_code]" style="width:480px;height:105px;">{-:$_O['site'][LANG_NAME]['stat_code']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_STAT_CODE_TIP-}
					</td>
				</tr>
				<tr>
					<td class="inputTitle">{-:@SITE_ADDON_META-} <span class="badge">{-php:echo '{';-}-:$_SITE['addon_meta']-}</span></td>
					<td class=""></td>
				</tr>
				<tr>
					<td class="inputArea">
						<textarea class="control-input ltr" name="site[{-:*LANG_NAME-}][addon_meta]" style="width:480px;height:105px;">{-:$_O['site'][LANG_NAME]['addon_meta']-}</textarea>
					</td>
					<td class="inputTip">
						{-:@SITE_ADDON_META_TIP-}
					</td>
				</tr>
			</table>
		{-foreach:$_LS,$alias,$lang-}
			{-if:$alias!==LANG_NAME-}
				<div style="display:none">
					<input type="text" name="site[{-:$alias-}][name]" value="{-:$_O['site'][$alias]['name']-}">
					<input type="text" name="site[{-:$alias-}][logo]" value="{-:$_O['site'][$alias]['logo']-}">
					<textarea name="site[{-:$alias-}][keywords]">{-:$_O['site'][$alias]['keywords']-}</textarea>
					<textarea name="site[{-:$alias-}][description]">{-:$_O['site'][$alias]['description']-}</textarea>
					<textarea name="site[{-:$alias-}][copyright]">{-:$_O['site'][$alias]['copyright']-}</textarea>
					<textarea name="site[{-:$alias-}][stat_code]">{-:$_O['site'][$alias]['stat_code']-}</textarea>
					<textarea name="site[{-:$alias-}][addon_meta]">{-:$_O['site'][$alias]['addon_meta']-}</textarea>
				</div>
			{-:/if-}
		{-:/foreach-}
	{-:/if-}
	</div>
	<div id="operation">
		<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
		<input name="token" type="hidden" value="{-:$_TK['token']-}">
		<span class="btn btn-info submit" action="{-url:admin@option/edit_option_site_do-}" to="#formEdit">{-:@SUBMIT-}</span>
		<input class="btn" type="reset" value="{-:@RESET-}">
	</div><!--/#operation-->
</form>

</div>
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__RES__-}js/editor/editor.js"></script>
<script src="{-:*__RES__-}js/editor/lang/{-:*LANG_NAME-}.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
<script src="{-:*__STYLE__-}js/editor.js"></script>
<script src="{-:*__STYLE__-}js/admin.js"></script>
<script src="{-:*__STYLE__-}js/option.js"></script>
</body>
</html>