<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:@GUESTBOOK-} - {-:$_SITE['name']-}</title>
<meta name="keywords" content="{-:$_SITE['keywords']-}" />
<meta name="description" content="{-:$_SITE['description']-}" />
{-include:clip/meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}',
	URL : {
		VCODE: '{-url:home@common/_captcha_img?name=vcode-}'
	}
};
</script>
</head>
<body>
{-include:clip/header-}

<div class="container margin-top">
	<div class="row">
		<div class="width-3-2">
			{-include:clip/current_position-}
		{-if:!empty($_V['error'])-}
			<div class="alert alert-warning">
			{-if:401==$_V['error']-}
				{-:@GUESTBOOK_INEXISTENCE_TIP-}
			{-elseif:402==$_V['error']-}
				{-:@GUESTBOOK_PENDING_TIP-}
			{-:/if-}
			</div>
		{-elseif:empty($_L)-}
			<div class="placeholder placeholder-lg text-center">{-:@LIST_EMPTY-}</div>
		{-else:-}
			<ul class="media-list list-line">
			{-foreach:$_L,$g-}
				<li class="media">
					{-if:!empty($g['g_no'])-}<div><i class="text-muted">{-:@NUMBERING-}: {-:$g['g_no']-}</i></div>{-:/if-}
					<div class="media-left">
						<a href="#">
							<img alt="{-:$g['g_author']-}" class="media-object" src="{-:*__APP__-}u/misc/avatar.png">
						</a>
					</div>
					<div class="media-body">
						<h4 class="media-heading">{-:$g['g_author']-}</h4>
						<p class="media-meta"><span class="attr">{-:$g['g_add_time']|get_dateStr~@me-}</span></p>
						<p class="media-content">{-:$g['g_content']-}</p>
						{-if:$g['g_reply']-}<div class="alert">
							<p>{-:$g['g_reply']-}</p>
							<p class="text-right"><span class="text-muted">{-:@REPLY_TIME-}: {-:$g['g_reply_time']|date~C('APP.TIME_FORMAT'),@me-}</span></p>
						</div><!--/.guestbook_reply-->{-:/if-}
					</div>
				</li>
			{-:/foreach-}
			</ul>
			{-include:clip/paging-}
		{-:/if-}
		{-if:EO('guestbook/switch')-}
			<div class="panel panel-success">
				<div class="panel-heading"><i class="icon-pencil-b"></i> {-:@ADD_GUESTBOOK-}</div>
				<div class="panel-body">
					<form id="fromAddReview" class="form" action="{-url:home@guestbook/add_guestbook_do-}" method="post">
						<fieldset>
							<div class="form-group">
								<label class="control-label">{-:@AUTHOR-}</label>
								<input type="text" name="g_author" value="{-:+author-}" validate="/\S+/" placeholder="{-:@AUTHOR_TIPS-}" class="control-input">
							</div>
							<div class="form-group">
								<label class="control-label">{-:@EMAIL-}</label>
								<input type="text" name="g_email" value="{-:+email-}" validate="/^[\w\-\.]+@[\w\-\.]+(\.\w+)+$/" placeholder="{-:@EMAIL_TIPS-}" class="control-input">
							</div>
							<div class="form-group">
								<label class="control-label">{-:@CONTENT-}</label>
								<textarea validate="/\S+/" class="control-input" style="height:70px;" name="g_content" placeholder="{-:@GUESTBOOK_CONTENT_TIPS-}"></textarea>
							</div>
							<div class="form-group">
								<label class="control-label">{-:@WHETHER_PUBLIC-}</label>
								<label class="control-label-item"><input value="0" name="g_private" checked="checked" type="radio"> {-:@PUBLIC-}</label>
								<label class="control-label-item"><input value="1" name="g_private" type="radio"> {-:@PRIVATE-}</label>
							</div>
						</fieldset>
						{-if:$_G['interaction']['captcha']-}<div class="margin-bottom">
							<div class="row">
								<div class="width-sm-3-1"><input id="vcodeInput" required="required" type="text" placeholder="{-:@CAPTCHA-}" name="vcode" autocomplete="off" value="" class="control-input" size="5" maxlength="5"></div>
								<div class="width-sm-3-2 text-muted"><span id="vcodeImg"></span> {-:@CAPTCHA_TIP-}</div>
							</div>
						</div>{-:/if-}
						<input name="timeKey" type="hidden" value="{-:$_TK['timeKey']-}">
						<input name="token" type="hidden" value="{-:$_TK['token']-}">
						<input type="submit" class="btn btn-info btn-block" value="{-:@SUBMIT-}">
					</form>
				</div>
			</div>
		{-:/if-}
		</div>
		<div class="width-3-1">
			<div class="panel">
				<div class="panel-heading"><i class="icon-zoom"></i> {-:@GUESTBOOK_QUERY-}</div>
				<div class="panel-body">
					<form id="formQueryGuestbook" action="{-url:home@guestbook/list_guestbook-}" class="form" method="post">
						<fieldset>
							<div class="form-group">
								<input required="required" type="text" validate="/\S+/" value="" name="g_no" class="control-input" maxlength="40" placeholder="{-:@MESSAGE_NUMBERING-}">
							</div>
							<div class="form-group">
								<input type="text" value="" name="g_password" class="control-input" maxlength="64" placeholder="{-:@QUERY_PASSWORD-}">
							</div>
							<input type="submit" class="btn btn-info btn-block" value="{-:@QUERY-}">
						</fieldset>
					</form>
				</div>
			</div>
			{-include:clip/sp-}
		</div>
	</div>
</div>

{-include:clip/footer-}
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}js/common.js"></script>
{-:$_SITE['stat_code']-}
</body>
</html>