<!doctype html>
<html dir="{-:*_LD_-}">
<head>
<meta charset="utf-8" />
<title>{-:$_V['sp_title']-} - {-:$_SITE['name']-}</title>
<meta name="keywords" content="{-:$_V['sp_keywords']-}" />
<meta name="description" content="{-:$_V['sp_description']-}" />
{-include:clip/meta-}
<script>
var GV = {
	_LD_ : '{-:*_LD_-}',
	LANG_NAME : '{-:*LANG_NAME-}'
};
</script>
</head>
<body>
{-include:clip/header-}

{-include:clip/current_position-}
<div class="container">
	<ul class="subnav subnav-pill margin">
	<loga:sp_list row="10">
		<li{-if:$_V['single_page_id'] == $item['single_page_id']-} class="active"{-:/if-}><a href="{-:$item['sp_url']-}">{-:$item['sp_title']-}</a></li>
	</loga:sp_list>
	</ul>

	<article class="article">
		<h1 class="article-title">{-:$_V['sp_title']-}</h1>
		<div class="article-meta">
			<span class="attr">{-:@PUBLISH_TIME-}: {-:$_V['sp_edit_time']|date~C('APP.TIME_FORMAT'),@me-}</span>
			{-if:$_V['sp_keywords']-}<span class="attr">{-:@KEYWORDS-}: {-:$_V['sp_keywords']-}</span>{-:/if-}
		</div>
		{-if:$_V['sp_description']-}<div class="article-lead text-sm">
			<p><strong>{-:@ABSTRACT-}</strong> {-:$_V['sp_description']-}</p>
		</div>{-:/if-}
		<div class="loga-main-content margin">{-:$_V['sp_content']-}</div>
		<div class="alert">
			<dl class="dl-horizontal">
				<dt>{-:@COMPANY-}</dt>
				<dd>{-:$_G['company_name']-}</dd>
				<dt>{-:@INTRODUCTION-}</dt>
				<dd>{-:$_G['company_introduction']-}</dd>
			</dl>
		</div>
	</article>
	<hr class="article-divider">
{-function:list_page|$spl,$curr-}
<ol>
{-foreach:$spl,$sp-}
	<li>
		<a{-if:$curr == $sp['single_page_id']-} class="text-strong text-danger"{-:/if-} href="{-:$sp['sp_url_o']-}">{-:$sp['sp_title']-}</a>
		{-if:isset($sp['sp_sub_page']) and !empty($sp['sp_sub_page'])-}
			{-call:list_page|$sp['sp_sub_page'],$curr-}
		{-:/if-}
	</li>
{-:/foreach-}
</ol>
{-:/function-}
	<div class="panel panel-box">
		{-call:list_page|$_V['sp_tree'],$_V['single_page_id']-}
	</div>
</div>
{-include:clip/footer-}
<script src="{-:*__RES__-}js/loga.js"></script>
<script src="{-:*__RES__-}js/jquery.js"></script>
<script src="{-:*__RES__-}fea/js/fea.min.js"></script>
<script src="{-:*__STYLE__-}mobile/js/common.js"></script>
{-:$_SITE['stat_code']-}
</body>
</html>