/** single page */
(function ($, LOGA) {

$(document).ready(function() {
	$('.single_page_select').each(function() {
		var container_id = $(this).attr('id'),
			sp_group = $(this).attr('sp_group'),
			single_page_id = $($(this).attr('to')).val(),
			exclude = $(this).attr('exclude');
		LOGA.util.get_single_page_select(container_id, sp_group, single_page_id, 'current', exclude);
	});
});

$(document).on('keyup', 'input[name="sp_title"]', function() {
	var single_page_id = $('#sp_parent_id').val();
	LOGA.util.get_html_naming(single_page_id);
}).on('keyup', '#sp_group', function() {
	$('#ac_parent_id_single_page_select').html('');
	$($('#ac_parent_id_single_page_select').attr('to')).val('');
	$('#ac_parent_id_single_page_select').attr('sp_group', $(this).val());
	LOGA.util.get_single_page_select("ac_parent_id_single_page_select", $(this).val(), 0, 'current');
	LOGA.util.get_html_naming(0);
})
.on('change', '#sp_group_select', function() {
	$('#sp_group').val($(this).val()).trigger('keyup');
})
.on('change', '.single_page_select select', function() {
	$(this).nextAll().remove();
	var container_id = $(this).parent().attr('id'),
		sp_group = $(this).parent().attr('sp_group'),
		single_page_id = $(this).val(),
		exclude = $(this).parent().attr('exclude');

	if('' != single_page_id) {
		LOGA.util.get_single_page_select(container_id, sp_group, single_page_id, 'sub', exclude);
		single_page_id = $(this).parent().children().last().val();
	}
	else {
		var _cv = $(this).parent().children().eq(-2).val();
		single_page_id = (1 != $(this).parent().children().length ^ '' == _cv) ? _cv : 0;
	}

	$($(this).parent().attr('to')).val(single_page_id);
	LOGA.util.get_group(single_page_id);
	LOGA.util.get_html_naming(single_page_id);
});

/* get single page select */
LOGA.util.get_single_page_select = function(container_id, sp_group, single_page_id, select_type, exclude) {
	$.getJSON(GV.URL.GET_SINGLE_PAGE_SELECT + '&sp_group=' + sp_group + '&single_page_id=' + single_page_id + '&select_type=' + select_type + '&exclude=' + exclude + '&' + Math.random(), function(result) {
		if(1 == result.data) {
			var str = '', slt, opt;

			for(var i = 0; i < result.info.length; i++) {
				slt = result.info[i];
				str += ' <select class="control-input input-inline">';
				str += '<option value="">----</option>';
				for(var k = 0; k < slt.length; k++) {
					opt = slt[k];
					if(opt.selected) {
						str += '<option value="' + opt.id + '" selected="selected">' + opt.name + '</option>';
					}
					else {
						str += '<option value="' + opt.id + '">' + opt.name + '</option>';
					}
				}
				str += '</select>';
			}

			if('sub' == select_type) {
				$('#' + container_id).append(str);
			}
			else if('current' == select_type) {
				$('#' + container_id).html(str);
			}
		}
		else if('' != result.info) {
			//alert(result.info);
		}
	});
}

/* get single page group */
LOGA.util.get_group = function(single_page_id) {
	$.getJSON(GV.URL.GET_GROUP + '&single_page_id=' + single_page_id + '&' + Math.random(), function(result) {
		if(1 == result.data) {
			var sp_group = result.info;
			$('input[name="sp_group"]').val(sp_group);
		}
	});
}

/* get parent html dir */
LOGA.util.get_html_naming = function(single_page_id) {
	if(!GV.EDIT_HTML_NAMING) {
		return;
	}
	var sp_title = $('input[name="sp_title"]').val();
	$.getJSON(GV.URL.GET_HTML_NAMING + '&single_page_id=' + single_page_id +'&sp_title=' + sp_title + '&' + Math.random(), function(result) {
		if(1 == result.data) {
			$('input[name="sp_html_naming"]').val(result.info);
		}
	});
}

})(jQuery, LOGA);
