<?php
/**
 * 嘿！
 * 这里是模板函数建议不要修改，如需修改请看我的注释！
 * BUG反馈地址：http://www3.info
*/
function dmeng_get_https_avatar($avatar) {
	//~ 替换为 https 的域名
	$avatar = str_replace(array("www.gravatar.com", "0.gravatar.com", "1.gravatar.com", "2.gravatar.com"), "secure.gravatar.com", $avatar);
	//~ 替换为 https 协议
	$avatar = str_replace("http://", "https://", $avatar);
	return $avatar;
}
add_filter('get_avatar', 'dmeng_get_https_avatar');

function rokophotolite_setup() {
    
    global $content_width;
    if (!isset($content_width)) {
        $content_width = 750;
    }

    // Takes care of the <title> tag.
    add_theme_support( 'title-tag' );

    // Add automatic feed links support. http://codex.wordpress.org/Automatic_Feed_Links
    add_theme_support('automatic-feed-links');

    // Add post thumbnails support. http://codex.wordpress.org/Post_Thumbnails
    add_theme_support('post-thumbnails');
    
    // Add custom background support. http://codex.wordpress.org/Custom_Backgrounds
    add_theme_support('custom-background', array(
        // Default color
        'default-color' => 'F6F9FA',
    ));
    
    // Add custom header support. http://codex.wordpress.org/Custom_Headers
    add_theme_support('custom-header', array(
        // Defualt image
        'default-image' => get_template_directory_uri() . '/img/01_services.jpg',
    	// Header text
    	'header-text' => false,
    ));

    // This theme uses wp_nav_menu().
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'rokophotolite' ),
	) );
}

add_action( 'after_setup_theme', 'rokophotolite_setup' );

// 添加js与css支持.如需更改为CDN公共库，在在主题发布页面查看教程
function rokophotolite_scripts() {
    wp_enqueue_style( 'rokophotolite_style', get_stylesheet_uri(), array('rokophotolite_bootstrap','rokophotolite_animate','rokophotolite_font_awesome'));
	wp_enqueue_style( 'rokophotolite_bootstrap', get_template_directory_uri() . '/css/bootstrap.css');
	wp_enqueue_style( 'rokophotolite_animate', get_template_directory_uri() . '/css/animate.css');
	wp_enqueue_style( 'rokophotolite_font_awesome', get_template_directory_uri() . '/css/font-awesome.css');
    wp_enqueue_style( 'rokophotolite_responsiveness', get_template_directory_uri() . '/css/responsiveness.css');

    if ( is_singular() ) wp_enqueue_script( 'comment-reply' );
    wp_enqueue_script( 'rokophotolite_modernizr', get_template_directory_uri() . '/js/modernizr.custom.js');

    wp_enqueue_script( 'rokophotolite_bootstrap', get_template_directory_uri() . '/js/bootstrap.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_wow', get_template_directory_uri() . '/js/wow.min.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_smooth_scroll', get_template_directory_uri() . '/js/SmoothScroll.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_easing', get_template_directory_uri() . '/js/jquery.easing.min.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_animate_header', get_template_directory_uri() . '/js/cbpAnimatedHeader.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_classie', get_template_directory_uri() . '/js/classie.js',array('jquery'),'',true);
    wp_enqueue_script( 'rokophotolite_main', get_template_directory_uri() . '/js/main.js',array('jquery'),'',true);
}

add_action( 'wp_enqueue_scripts', 'rokophotolite_scripts' );

// 如果为IE浏览器则调用此css/js.
function rokophotolite_ie () {
    echo '<!--[if lt IE 9]>' . "\n";
    echo '<script src="'. get_template_directory_uri() . '/js/html5shiv.min.js"></script>' . "\n";
    echo '<script src="'. get_template_directory_uri() . '/js/respond.min.js"></script>' . "\n";
    echo '<![endif]-->' . "\n";
}
add_action('wp_head', 'rokophotolite_ie');

/**
 * Menu fallback. Link to the menu editor if that is useful.
 *
 * @param  array $args
 * @return string
*/

function rokophotolite_new_setup($args)
{
    // see wp-includes/nav-menu-template.php for available arguments

	extract($args);
	$link = $link_before . '<a href="' . esc_url( home_url( '/' ) ) . '">' . $before . __( 'Home', 'rokophotolite' ) . $after . '</a>' . $link_after;

	// We have a list

	if (FALSE !== stripos($items_wrap, '<ul') or FALSE !== stripos($items_wrap, '<ol')) {
		$link = "<li class='menu-item'>$link</li>";
	}

	$output = sprintf($items_wrap, $menu_id, $menu_class, $link);
	if (!empty($container)) {
		$output = '<' . esc_attr( $container) . ' class="' . esc_attr( $container_class ) . '" id="' . esc_attr( $container_id ) . '">' . esc_textarea( $output ) . '</' . esc_attr( $container ) . '>';
	}

	if ($echo) {
		echo $output;
	}

	return $output;
}

function rokophotolite_comment($comment, $args, $depth) {
$GLOBALS['comment'] = $comment;
?>
<li <?php comment_class('comment even thread-even'); ?> id="comment-<?php comment_ID() ?>">
    <table class="comment-container wow fadeIn">
        <tr>
            <td class="comment-avatar">
                <?php echo get_avatar( $comment, 70 ); ?>
            </td>
            <td class="comment-data">
                <div class="comment-header">
                    <span class="comment-author"><?php printf(__('%s'), get_comment_author_link()) ?></span>
                    <span class="comment-date"><?php echo get_comment_date(); ?> <?php _e('on', 'rokophotolite'); ?> <?php echo get_comment_time(); ?></span>
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
                <div class="comment-body">
                    <?php if ($comment->comment_approved == '0') : ?>
                        <em><?php _e('Your comment is awaiting moderation.', 'rokophotolite') ?></em><br />
                    <?php endif; ?>
                    <?php comment_text(); ?>
                </div>
            </td>
        </tr>
    </table>
<?php
}

function rokophotolite_css() {
    if ( is_user_logged_in() ) {
?>
<style>
.comment-login {
    width: 100% !important;
}
</style>
<?php
    }
}
add_action('wp_head', 'rokophotolite_css');

function rokophotolite_customize_register($wp_customize)
{
	class RokoPhoto_Theme_Support_Slider extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info/505.html">PRO version</a> add a Slider on frontpage!','rokophotolite');
		}
	}
	class RokoPhoto_Theme_Support_Vision extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info">使用帮助</a> add a Vision Slider on frontpage!','rokophotolite');
		}
	}
	class RokoPhoto_Theme_Support_Portfolio extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info">Theme</a> add a Portfolio section on frontpage!','rokophotolite');
		}
	}
	class RokoPhoto_Theme_Support_Ribbon extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info">PRO version</a> add a Ribbon section on frontpage!','rokophotolite');
		}
	}
	class RokoPhoto_Theme_Support_AboutUs extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info">PRO version</a> add an About us section on frontpage!','rokophotolite');
		}
	}
	class RokoPhoto_Theme_Support_Contact extends WP_Customize_Control
	{
		public function render_content()
		{
			echo __('Check out the <a href="https://www3.info">PRO version</a> add a Contact section on frontpage!','rokophotolite');
		}
	}
	
    $wp_customize->add_section('rokophotolite_logo_section', array(
        'priority' => 25,
        'title' => __('站点 Logo', 'rokophotolite'),
    ));
    
    $wp_customize->add_section('rokophotolite_subhead_section', array(
        'priority' => 50,
        'title' => __('欢迎语', 'rokophotolite'),
    ));
	

	
	$wp_customize->add_setting(
        'rokophotolite_slider_upsale', array('sanitize_callback' => 'rokophotolite_sanitize_pro_version')
	);
	
	$wp_customize->add_control( new RokoPhoto_Theme_Support_Slider( $wp_customize, 'rokophotolite_slider_upsale',
	    array(
	        'section' => 'rokophotolite_slider_upsale',
	   )
	));
	
	$wp_customize->add_setting(
        'rokophotolite_contact_upsale', array('sanitize_callback' => 'rokophotolite_sanitize_pro_version')
	);
	
	$wp_customize->add_control( new RokoPhoto_Theme_Support_Contact( $wp_customize, 'rokophotolite_contact_upsale',
	    array(
	        'section' => 'rokophotolite_contact_upsale',
	   )
	));
	

    $wp_customize->add_section('rokophotolite_footer_section', array(
        'priority' => 60,
        'title' => __('底部杂项', 'rokophotolite'),
    ));

    $wp_customize->add_setting('rokophotolite_logo_image', array(
        'default' => get_template_directory_uri().'/img/logo.png',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'rokophotolite_logo_image', array(
        'label' => __('Site Logo Image', 'rokophotolite'),
        'section' => 'rokophotolite_logo_section',
        'priority' => 5,
        'settings' => 'rokophotolite_logo_image'
    )));

    $wp_customize->add_setting('rokophotolite_subhead_title', array(
        'default' => 'Welcome to',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('rokophotolite_subhead_title', array(
        'label' => __('顶部欢迎语', 'rokophotolite'),
        'section' => 'rokophotolite_subhead_section',
        'priority' => 5,
        'settings' => 'rokophotolite_subhead_title'
    ));

    $wp_customize->add_setting('rokophotolite_social_label', array(
        'default' => '这是个性展示框上方文字',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('rokophotolite_social_label', array(
        'label' => __('盒子标签', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 5,
        'settings' => 'rokophotolite_social_label'
    ));

    $wp_customize->add_setting('rokophotolite_social_text', array(
        'default' => 'Follow Me',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('rokophotolite_social_text', array(
        'label' => __('展示框文字', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 10,
        'settings' => 'rokophotolite_social_text'
    ));

    $wp_customize->add_setting('rokophotolite_facebook_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_facebook_link', array(
        'label' => __('Facebook URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 15,
        'settings' => 'rokophotolite_facebook_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_twitter_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_twitter_link', array(
        'label' => __('Twitter URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 20,
        'settings' => 'rokophotolite_twitter_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_behance_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_behance_link', array(
        'label' => __('Behance URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 25,
        'settings' => 'rokophotolite_behance_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_dribbble_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_dribbble_link', array(
        'label' => __('Dribbble URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 30,
        'settings' => 'rokophotolite_dribbble_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_flickr_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_flickr_link', array(
        'label' => __('Flickr URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 35,
        'settings' => 'rokophotolite_flickr_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_googleplus_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_googleplus_link', array(
        'label' => __('Google + URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 40,
        'settings' => 'rokophotolite_googleplus_link'
    ));
    
    $wp_customize->add_setting('rokophotolite_instagram_link', array(
        'default' => '#',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('rokophotolite_instagram_link', array(
        'label' => __('Instagram URL', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 45,
        'settings' => 'rokophotolite_instagram_link'
    ));

    $wp_customize->add_setting('rokophotolite_footer_copyrights', array(
        'default' => '此设置无效',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('rokophotolite_footer_copyrights', array(
        'label' => __('Footer Copyrights', 'rokophotolite'),
        'section' => 'rokophotolite_footer_section',
        'priority' => 50,
        'settings' => 'rokophotolite_footer_copyrights'
    ));
}
add_action('customize_register', 'rokophotolite_customize_register');

function rokophotolite_registers() {
   
	wp_register_script( 'rokophotolite_customizer_script', get_template_directory_uri() . '/js/rokophoto-lite_customizer.js', array("jquery"), '20120206', true  );
	wp_enqueue_script( 'rokophotolite_customizer_script' );
	
	wp_localize_script( 'rokophotolite_customizer_script', 'objectL10n', array(
		
		'documentation' => __( '[ 使用文档 ]', 'rokophotolite' ),
		'pro' => __('&nbsp;&nbsp;[ BUG反馈 ]&nbsp;','rokophotolite')
		
	) );
}
add_action( 'customize_controls_enqueue_scripts', 'rokophotolite_registers' );

function rokophotolite_sanitize_pro_version( $input ) {
    return $input;
}