<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to bushwick_comment() which is
 * located in the inc/template-tags.php file.
 *
 * @package Bushwick
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) :
	return;
endif;
?>

<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>

	<h2 class="comments-title">
		<?php
			printf( _nx( '已有1条评论', '已有%1$s 条评论', get_comments_number(), 'comments title', 'bushwick' ),
				number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
		?>
	</h2>

	<ol class="comment-list">
		<?php
			/* Loop through and list the comments. Tell wp_list_comments()
			 * to use bushwick_comment() to format the comments.
			 * If you want to overload this in a child theme then you can
			 * define bushwick_comment() and that will be used instead.
			 * See bushwick_comment() in inc/template-tags.php for more.
			 */
			wp_list_comments( array(
				'callback'    => 'bushwick_comment',
				'avatar_size' => 75,
			) );
		?>
	</ol><!-- .comment-list -->

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
	<nav id="comment-nav-below" class="navigation-comment" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Comment navigation', 'bushwick' ); ?></h1>
		<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'bushwick' ) ); ?></div>
		<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'bushwick' ) ); ?></div>
	</nav><!-- #comment-nav-below -->
	<?php endif; // check for comment navigation ?>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), '评论' ) ) :
	?>
	<p class="no-comments"><?php _e( '评论关闭.', 'bushwick' ); ?></p>
	<?php endif; ?>

	<?php comment_form(); ?>

</div><!-- #comments -->
