<?php
defined('KONG_PATH') || exit;

/**
 * 模型最新文件列表模块
 * @param int mid 模型ID
 * @param string dateformat 时间格式
 * @param string orderby 排序方式
 * @param int orderway 降序(-1),升序(1)
 * @return array
 */
function kp_block_newlist($conf) {
	global $run;

	// hook kp_block_newlist_before.php

	$mid = isset($_GET['mid']) ? intval($_GET['mid']) : _int($conf, 'mid', 2);
	$titlenum = isset($conf['titlenum']) ? (int)$conf['titlenum'] : 0;
	$intronum = isset($conf['intronum']) ? (int)$conf['intronum'] : 0;
	$dateformat = empty($conf['dateformat']) ? 'Y-m-d H:i:s' : $conf['dateformat'];
	$orderby = isset($conf['orderby']) && in_array($conf['orderby'], array('id', 'dateline')) ? $conf['orderby'] : 'id';
	$orderway = isset($conf['orderway']) && $conf['orderway'] == 1 ? 1 : -1;

	$table_arr = &$run->_cfg['table_arr'];
	$table = isset($table_arr[$mid]) ? $table_arr[$mid] : 'article';

	// 初始模型表名
	$run->cms_content->table = 'cms_'.$table;
		
	$where = array();
	$newlist_arr = $run->cms_content->find_fetch($where, array($orderby => $orderway), 0, 10);	
	// 读取内容列表
	
	foreach($newlist_arr as &$v) {		
		$run->cms_content->format($v, $mid, $dateformat, $titlenum, $intronum);		
	}

	// hook kp_block_newlist_after.php
	
	return array('newlist'=> $newlist_arr);
}
