/**
 * @package iCMS
 *
 * jquery.scaling.js v0.1.0
 * jQuery Image Scaling Plugin
 * @author coolmoo<idreamsoft@qq.com>
 * @param int width
 * @param int height
 * @param string loadpic
**/
jQuery.fn.scaling=function(width,height,loadpic){
    loadpic=loadpic||"admin/images/ajax_loader.gif";
	return this.each(function(){
		var obj	= $(this);
		var img	= new Image();
		img.src	= obj.attr("src");
//		//自动缩放图片
		var presize=function(){
			var w = img.width, h = img.height;
			if(w > h && h > height){
				w = (height/h) * w;
				h = height;
			}else if(h > w && w > width){
				h = (width/w) * h;
				w = w;
			}
			obj.width(w).height(h);
		};
//处理FF下会自动读取缓存图片
		if(img.complete){
			presize();
		    return;
		}
		obj.attr("src",loadpic);
		var loadimg	= new Image();
		loadimg.src	= loadpic;
		obj.width(loadimg.width).height(loadimg.height);
		$(img).load(function(){
			presize();
			obj.attr("src",this.src).show();
		});
	});
}
jQuery.fn.snap=function(a,w,h,left,top,loading){
	a = a|| "src";
    w = w|| "400";h = h	|| "400";
    left = left|| 10;top = top || 10;
    loading = loading|| "admin/images/ajax_loader.gif";
    return this.each(function(){
    	$("#bigsnap").remove();
    	$("body").append('<div id="bigsnap"><img id="snap" src="'+loading+'" /></div>');
    	var value		= $(this).attr(a);
		var timeOutID 	= null;
		var hideSnap 	= function(){$("#bigsnap").hide();};
		$(this).mouseover(function(){
			window.clearTimeout(timeOutID);
			if(!in_array(value.substr(value.lastIndexOf(".")+1), ['gif', 'jpeg', 'jpg', 'png', 'bmp'])|| value==loading){
				return;
			}
			var offset 	= $(this).offset();
			var snapTop = offset.top+top;
			var snapLeft= offset.left+left;
			$("#bigsnap").css({"top" : snapTop, "left" : snapLeft}).show();
			$("#snap").attr("src",value).scaling(w,h)
			.mouseover(function(){
				window.clearTimeout(timeOutID);
				$("#bigsnap").show();
			}).mouseout(function(){
				$("#bigsnap").hide();
			});
		}).mouseout(function(){
			timeOutID = window.setTimeout(hideSnap,1000);
		});
    });
};