<?php
/*
Plugin Name: 语言翻译器
Plugin URI: http://www.nothing2hide.net/wp-plugins/wordpress-global-translator-plugin/
Description: 能自动将您的博客内容翻译成多达34种语言(英语，法语，意大利语，德语，葡萄牙语，西班牙语，日语，韩语，中国，阿拉伯文，俄文，希腊，荷兰，挪威，保加利亚，捷克，克罗地亚，丹麦，芬兰，印度，波兰，罗马尼亚和瑞典...) . 将其上传至wordpress的插件文件夹后启用该插件 成功启用后对该插件进行<a href="options-general.php?page=translator/options-translator.php">进行相关设置</a> 
Version: 
Author: 由w_sd汉化
Author URI: http://www.k488.cn
Disclaimer: 只提供使用，不负任何责任
*/

/*  Copyright 2006  Davide Pozza  (email : davide@nothing2hide.net)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Credits:
Special thanks also to Jason F. Irwin, Ibnu Asad, Ozh, ttancm, Fable, Satollo, Nick Georgakis and the many others who have provided feedback, spotted bugs, and suggested improvements.
*/

/* *****INSTRUCTIONS*****

Installation
============
Upload the folder "global-translator" into your "wp-content/plugins" directory.
Log in to Wordpress Administration area, choose "Plugins" from the main menu, find "Global Translator" 
and click the "Activate" button. From the main menu choose "Options->Global Translator" and select 
your blog language and your preferred configuration options then select "Update Options".

Upgrading
=========
If upgrading from 0.9 or higher, just overwrite the previous version, otherwise uninstall the previous 
version and follow the Installation instructions.

Configuration
=============
If your theme is widged-enabled, just choose "Presentation->Widgets" from the administration main menu
and drag the "Global translator" widget on the preferred position on your sidebar.
If your theme is not widgetized, just add the following php code (usually to the sidebar.php file):  
<?php if(function_exists("gltr_build_flags_bar")) { gltr_build_flags_bar(); } ?>

After this simple operation, a bar containing the flags that represents all the available translations 
for your language will appear on your blog.

Uninstallation
==============
Log in to Wordpress Administration area, choose "Plugins" from the main menu, find the name of the 
plugin "Global Translator", and click the "Deactivate" button.


*/

require_once (dirname(__file__).'/header.php');

	
define('HARD_CLEAN', true);

define('FLAG_BAR_BEGIN', '<!--FLAG_BAR_BEGIN-->');
define('FLAG_BAR_END', '<!--FLAG_BAR_END-->');
define('USER_AGENT','Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.2.1) Gecko/20021204');

define('LANGS_PATTERN', 'it|ko|zh-CN|pt|en|de|fr|es|ja|ar|ru|el|nl|zh|zt|no|bg|cs|hr|da|fi|hi|pl|ro|sv|ca|tl|iw|id|lv|lt|sr|sk|sl|uk|vi');
define('LANGS_PATTERN_WITH_SLASHES', '/it/|/ko/|/zh-CN/|/pt/|/en/|/de/|/fr/|/es/|/ja/|/ar/|/ru/|/el/|/nl/|/zh/|/zt/|/no/|/bg/|/cs/|/hr/|/da/|/fi/|/hi/|/pl/|/ro/|/sv/|/ca/|/tl/|/iw/|/id/|/lv/|/lt/|/sr/|/sk/|/sl/|/uk/|/vi/');
define('LANGS_PATTERN_WITHOUT_FINAL_SLASH', '/it|/ko|/zh-CN|/pt|/en|/de|/fr|/es|/ja|/ar|/ru|/el|/nl|/zh|/zt|/no|/bg|/cs|/hr|/da|/fi|/hi|/pl|/ro|/sv|/ca|/tl|/iw|/id|/lv|/lt|/sr|/sk|/sl|/uk|/vi');


define('CONN_INTERVAL', get_option('gltr_conn_interval'));
define('DEBUG', get_option('gltr_enable_debug'));
define('BASE_LANG', get_option('gltr_base_lang'));
define('BAR_COLUMNS', get_option('gltr_col_num'));
define('BAN_PREVENTION', get_option('gltr_ban_prevention'));
define('HTML_BAR_TAG', get_option('gltr_html_bar_tag'));
define('TRANSLATION_ENGINE', get_option('gltr_my_translation_engine'));
define('SITEMAP_INTEGRATION', get_option('gltr_sitemap_integration'));
define('EXPIRE_TIME', get_option('gltr_cache_expire_time'));
define('COMPRESS_CACHE', get_option('gltr_compress_cache'));
define('BLOG_URL', get_settings('siteurl'));
define('BLOG_HOME', get_settings('home'));
define('BLOG_HOME_ESCAPED', str_replace('/', '\\/', BLOG_HOME));


$gltr_result = '';
$gltr_engine = $gltr_available_engines[TRANSLATION_ENGINE];

add_filter('query_vars', 'gltr_insert_my_rewrite_query_vars');
add_action('parse_query', 'gltr_insert_my_rewrite_parse_query');
add_action('admin_menu', 'gltr_add_options_page');
add_action('init', 'gltr_translator_init');

add_action('save_post', 'gltr_erase_common_cache_files');
add_action('delete_post', 'gltr_erase_common_cache_files');
//add_action('comment_post', 'gltr_erase_common_cache_files');
//add_action('publish_phone', 'gltr_erase_common_cache_files');
//add_action('trackback_post', 'gltr_erase_common_cache_files');
//add_action('pingback_post', 'gltr_erase_common_cache_files');
//add_action('edit_comment', 'gltr_erase_common_cache_files');
//add_action('wp_set_comment_status', 'gltr_erase_common_cache_files');
//add_action('delete_comment', 'gltr_erase_common_cache_files');
//add_action('switch_theme', 'gltr_erase_common_cache_files');

if (SITEMAP_INTEGRATION) add_action("sm_buildmap","gltr_add_translated_pages_to_sitemap");

function gltr_translator_init() {
  global $wp_rewrite;
  if (isset($wp_rewrite) && $wp_rewrite->using_permalinks()) {
    define('REWRITEON', true);
    define('LINKBASE', $wp_rewrite->root);
  } else {
    define('REWRITEON', false);
    define('KEYWORDS_REWRITEON', '0');
    define('LINKBASE', '');
  }
  if (REWRITEON) {
    add_filter('generate_rewrite_rules', 'gltr_translations_rewrite');
  }
  if (!is_readable(dirname(__file__)) || !is_writable(dirname(__file__)) ){
    die ("Unable to complete Global Translator initialization. Plese make writable and readable the following directory:
    <ul><li>".dirname(__file__)."</li></ul>");  
  }
}

function gltr_add_translated_pages_to_sitemap() {
	$start= round(microtime(true),4);
	@set_time_limit(120);
  global $wpdb;
	if (gltr_sitemap_plugin_detected()){
		$generatorObject = &GoogleSitemapGenerator::GetInstance();
	  $posts = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_status = 'publish' AND post_password='' ORDER BY post_modified DESC");
  	$chosen_langs = get_option('gltr_preferred_languages');
  	
  	//homepages
		foreach($chosen_langs as $lang){
			$trans_link = "";
			if (REWRITEON){
				$trans_link = preg_replace("/".BLOG_HOME_ESCAPED."/", BLOG_HOME . "/$lang/" , BLOG_HOME );
			} else {
				$trans_link = BLOG_HOME . "?lang=$lang";
			}
			if (gltr_is_cached($trans_link))
				$generatorObject->AddUrl($trans_link,time(),"daily",1);
		}
		
		//posts
		foreach ($posts as $post) {
			$permalink = get_permalink($post->ID);
			foreach($chosen_langs as $lang){
				$trans_link = "";
				if (REWRITEON){
					$trans_link = preg_replace("/".BLOG_HOME_ESCAPED."/", BLOG_HOME . "/" . $lang, $permalink );
				} else {
					$trans_link = $permalink . "&lang=$lang";
				}
				if (gltr_is_cached($trans_link))
					$generatorObject->AddUrl($trans_link,time(),"weekly",0.2);
			}
		}
	}
  $end = round(microtime(true),4);
 	gltr_debug("Translated pages sitemap addition process total time:". ($end - $start) . " seconds");
	
}

function gltr_build_translation_url($srcLang, $destLang, $urlToTransl) {
  global $gltr_engine;
  if (TRANSLATION_ENGINE == 'google'){
  	$urlToTransl = str_replace(array('?','='),array('%3F','%3D'),$urlToTransl);
  }else if (TRANSLATION_ENGINE == 'babelfish'){	
		$urlToTransl = urlencode($urlToTransl);   
	}
  $tokens = array('${URL}', '${SRCLANG}', '${DESTLANG}');
  $srcLang = $gltr_engine->decode_lang_code($srcLang);
  $destLang = $gltr_engine->decode_lang_code($destLang);
  $values = array($urlToTransl, $srcLang, $destLang);
  $res = str_replace($tokens, $values, $gltr_engine->get_base_url());
  if (TRANSLATION_ENGINE == 'google'){
    gltr_debug("Google Patch: calling: $res");
    $maincont = gltr_http_get_content( $res);
		$matches = array();
		preg_match( '/(http:\/\/[0-9\.]*\/translate_c[^"]*)"/',$maincont,$matches);
		$res = $matches[1];
		$res = str_replace('&amp;','&', $res);    
		
	} else if (TRANSLATION_ENGINE == 'babelfish'){
    gltr_debug("Babelfish Patch: calling: $res");
    $maincont = gltr_http_get_content( $res);
		$matches = array();
		preg_match( '/URL=(http:\/\/[0-9\.]*\/babelfish\/translate_url_content[^"]*)"/',$maincont,$matches);
		$res = $matches[1];
		$res = str_replace('&amp;','&', $res);    
	}
  /*
  if ($gltr_engine->get_name() == 'freetransl'){
    $tmp_buf = gltr_http_get_content("http://www.freetranslation.com/");
    $matches = array();
    preg_match(
      '/\<input type="hidden" name="username" value="([^"]*)" \/>\<input type="hidden" name="password" value="([^"]*)" \/>/',$tmp_buf,$matches);
      
    $res .= "&username=$matches[1]&password=$matches[2]";
  }*/
  gltr_debug("Translation URL: $res");
  return $res;
} 


function gltr_translate($lang, $url) {
  global $gltr_engine;
	$unavail_message = "<html><style>html,body {font-family: arial, verdana, sans-serif; font-size: 14px;margin-top:0px; margin-bottom:0px; height:100%;}</style><body><center><br /><br /><b>This page has not been translated yet.<br />The translation process could take a while: please come back later.</b><br /><br /><a href='".get_settings('home')."'>Home page</a></center></body></html>";
  
  $url = gltr_get_self_url();

  if (!gltr_is_connection_allowed()){
  	//gltr_debug("Translation not allowed for url: $url");
		return $unavail_message;
	}
  
  if (REWRITEON) {
    $pattern1 = '/(' . BLOG_HOME_ESCAPED . ')(\\/(' . LANGS_PATTERN . ')\\/)(.+)/';
    $pattern2 = '/(' . BLOG_HOME_ESCAPED . ')\\/(' . LANGS_PATTERN . ')[\\/]{0,1}$/';

    if (preg_match($pattern1, $url)) {
      $url_to_translate = preg_replace($pattern1, '\\1/\\4', $url);
    } elseif (preg_match($pattern2, $url)) {
      $url_to_translate = preg_replace($pattern2, '\\1', $url);
    }
  } else {
    $url_to_translate = preg_replace('/[\\?&]{0,1}lang\\=(' . LANGS_PATTERN . ')/i', '', $url);    
  	//gltr_debug("==>$url|$url_to_translate");
  }

  $resource = gltr_build_translation_url(BASE_LANG, $lang, $url_to_translate);
  
  $buf = gltr_http_get_content($resource);
	
	if (gltr_is_valid_translated_content($buf)){
  	gltr_store_translation_engine_status('working');
		return gltr_clean_translated_page($buf, $lang);
	} else {
  	gltr_store_translation_engine_status('banned');
  	gltr_debug("Bad translated content for url: $buf");
		return $unavail_message;
	}
}

function gltr_http_get_content($resource) {
  $isredirect = true;
  $redirect = null;
	
	while ($isredirect) {
    $isredirect = false;
    if (isset($redirect_url)) {
      $resource = $redirect_url;
    }

    $url_parsed = parse_url($resource);
    $host = $url_parsed["host"];
    $port = $url_parsed["port"];
    if ($port == 0)
      $port = 80;
    $path = $url_parsed["path"];
    if (empty($path))
      $path = "/";
    $query = $url_parsed["query"];
    $http_q = $path . '?' . $query;

    $req = gltr_build_request($host, $http_q);
				
    $fp = @fsockopen($host, $port, $errno, $errstr);

    if (!$fp) {
      return "$errstr ($errno)<br />\n";
    } else {
      fputs($fp, $req, strlen($req)); // send request
      $buf = '';
      $isFlagBar = false;
      $flagBarWritten = false;
      $beginFound = false;
      $endFound = false;
      $inHeaders = true;
			$prevline='';
      while (!feof($fp)) {
        $line = fgets($fp);
        if ($inHeaders) {
        	
          if (trim($line) == '') {
            $inHeaders = false;
            continue;
          }

          $prevline = $line;
          if (!preg_match('/([^:]+):\\s*(.*)/', $line, $m)) {
            // Skip to the next header
            continue;
          } 
          $key = strtolower(trim($m[1]));
          $val = trim($m[2]);
					if ($key == 'location') {
            $redirect_url = $val;
          	$isredirect = true;
          	break;
          }
          continue;
        }
				
        $buf .= $line;
      } //end while
    }
    fclose($fp);
  } //while($isredirect) 
  return $buf; 
}


function gltr_is_valid_translated_content($content){
	return (strpos($content, FLAG_BAR_BEGIN) > 0 && strpos($content, FLAG_BAR_END) > 0);
}

function gltr_store_translation_engine_status($status){
	$exists = get_option("gltr_translation_status");
	if($exists === false){ 
		add_option("gltr_translation_status","unknown");
	}
	update_option("gltr_translation_status",$status);	
}

function gltr_is_connection_allowed(){

	$last_connection_time = get_option("gltr_last_connection_time");
	if($last_connection_time === false){ 
		add_option("gltr_last_connection_time",0);
		$last_connection_time = 0;
	} 
	
	if ($last_connection_time > 0){
		$now = time();
		$delta = $now - $last_connection_time;
		if ($delta < CONN_INTERVAL){
			gltr_debug("Blocking connection request: last_connection_time=$last_connection_time now=$now delta=$delta ");
			$res = false;
		} else {
			gltr_debug("Allowing connection request: last_connection_time=$last_connection_time now=$now delta=$delta ");
			update_option("gltr_last_connection_time", $now);
	    $res = true;
	  }
	} else {
		gltr_debug("Warning: 'last_connection_time' is undefined: allowing translation");
		update_option("gltr_last_connection_time", time());
		$res = true;
	}
	return $res;
}

function gltr_clean_link($matches){
  //global $wp_query;
  //$lang = $wp_query->query_vars['lang'];
  if (TRANSLATION_ENGINE == 'google')
		return "href=\"" . urldecode($matches[1]) . $matches[3] . "\"";
	else if (TRANSLATION_ENGINE == 'promt')
		return "href=\"" . urldecode($matches[1]) . "\"";
	else 
		return "href=\"" . urldecode($matches[1]) . "\"";
}

function gltr_clean_translated_page($buf, $lang) {
  global $gltr_engine;
  
	$patterns = $gltr_engine->get_links_pattern();
	foreach( $patterns as $id => $pattern){
  	$buf = preg_replace_callback($pattern, "gltr_clean_link", $buf);
  }
	
  $buf = preg_replace("/<meta name=\"description\"([ ]*)content=\"([^>]*)\"([ ]*)\/>/i", "", $buf);
  $buf = preg_replace("/<meta name='description'([ ]*)content='([^>]*)'([ ]*)\/>/i", "", $buf);
	//TODO: add <meta name="language" content="LANG" />
  if (REWRITEON) {
    $pattern = "/<a([^>]*)href=\"" . BLOG_HOME_ESCAPED . "(((?![\"])(?!\/trackback)(?!\/feed)" . gltr_get_extensions_skip_pattern() . ".)*)\"([^>]*)>/i";
  	$repl = "<a\\1href=\"" . BLOG_HOME . '/' . $lang . "\\2\" \\7>";
    $buf = preg_replace($pattern, $repl, $buf);
  } else {
    $pattern = "/<a([^>]*)href=\"" . BLOG_HOME_ESCAPED . "\/\?(((?![\"])(?!\/trackback)(?!\/feed)" . gltr_get_extensions_skip_pattern() . ".)*)\"([^>]*)>/i";
    $repl = "<a\\1href=\"" . BLOG_HOME . "?\\2&lang=$lang\" \\7>";
    $buf = preg_replace($pattern, $repl, $buf);
    
    $pattern = "/<a([^>]*)href=\"" . BLOG_HOME_ESCAPED . "[\/]{0,1}\"([^>]*)>/i";
    $repl = "<a\\1href=\"" . BLOG_HOME . "?lang=$lang\" \\2>";
    $buf = preg_replace($pattern, $repl, $buf);
  }

  //let's remove custom tags added by certain engines
  if (TRANSLATION_ENGINE == 'promt') {
    //$buf = preg_replace("/\<div class='PROMT_HEADER'(.*)\<\/div\>/i", "", $buf);
    //$buf = preg_replace("/\<span class=\"UNKNOWN_WORD\"\>([^\<]*)\<\/span\>/i", "\\1",$buf);
    $buf = preg_replace("/onmouseout=\"OnMouseLeaveSpan\(this\)\"/i", "",$buf);
    $buf = preg_replace("/onmouseover=\"OnMouseOverSpanTran\(this,event\)\"/i", "",$buf);
    $buf = preg_replace("/<span class=\"src_para\">/i", "<span style=\"display:none;\">",$buf);
  } else if (TRANSLATION_ENGINE == 'freetransl') {
    $buf = preg_replace("/\<div(.*)http:\/\/www\.freetranslation\.com\/images\/logo\.gif(.*)\<\/div\>/i", "", $buf);
    $buf = str_replace(array("{L","L}"), array("",""), $buf);
  } else if (TRANSLATION_ENGINE == 'google') {
    $buf = preg_replace("/<script>[^<]*<\/script><script src=\"[^\"]*translate_c.js\"><\/script><script>_intlStrings[^<]*<\/script><style type=\"text\/css\">\.google-src-text[^<]*<\/style>/i", "",$buf);
    $buf = preg_replace("/_setupIW\(\);_csi\([^\)]*\);/","",$buf);
    $buf = preg_replace("/onmouseout=\"_tipoff\(\)\"/i", "",$buf);
    $buf = preg_replace("/onmouseover=\"_tipon\(this\)\"/i", "",$buf);
    $buf = preg_replace("/<span class=\"google-src-text\"[^>]*>/i", "<span style=\"display:none;\">",$buf);
  }
  
	if (HARD_CLEAN){
		$out = array();
		$currPos=0;
		$result = "";
		$tagOpenPos = 0;
		$tagClosePos = 0;
		
		while (!($tagOpenPos === false)){
			$beginIdx = $tagClosePos;
			$tagOpenPos = strpos($buf,"<span style=\"display:none;\">",$currPos);
			$tagClosePos = strpos($buf,"</span>",$tagOpenPos);
			if ($tagOpenPos == 0 && ($tagOpenPos === false) && strlen($result) == 0){
				gltr_debug("===>break all!");
				$result = $buf;
				break;
			}
			$offset = substr($buf,$tagOpenPos,$tagClosePos - $tagOpenPos + 7);
			preg_match_all('/<span[^>]*>/U',$offset,$out2,PREG_PATTERN_ORDER);
			$nestedCount = count($out2[0]);
			
			for($i = 1; $i < $nestedCount; $i++){
				$tagClosePos = strpos($buf,"</span>",$tagClosePos + 7);
			}
			if ($beginIdx > 0)$beginIdx += 7;
			
			$result .= substr($buf,$beginIdx,$tagOpenPos - $beginIdx);
			$currPos = $tagClosePos;
		}
		//gltr_debug($result);
		$buf = $result . substr($buf,$beginIdx);//Fixed by adding the last part of the translation: thanks Nick Georgakis!
	}
  
  $buf = gltr_insert_flag_bar($buf);
  
  return $buf;
}


function gltr_insert_flag_bar($buf){
	$bar = gltr_get_flags_bar();

	if (gltr_is_valid_translated_content($buf)){
    $buf = substr($buf, 0, strpos($buf, FLAG_BAR_BEGIN)) . $bar . substr($buf,
      strpos($buf, FLAG_BAR_END) + strlen(FLAG_BAR_END));
  } else {
    gltr_debug("Flags bar tokens not found: translation failed or denied");
  }
  
  return $buf;
}

function gltr_get_extensions_skip_pattern() {
	global $well_known_extensions;
	
	$res = "";
	foreach ($well_known_extensions as $key => $value) {
		$res .= "(?!\.$value)";
	}
	return $res;
}

function gltr_get_random_UA(){
	global $gltr_ua;
	$tot = count($gltr_ua);
	$id = rand( 0, count($gltr_ua)-1 );
	$ua = $gltr_ua[$id];
	//gltr_debug("Random UA nr $id: $ua");
	return $ua;
}

function gltr_build_request($host, $http_req) {
  $res = "GET $http_req HTTP/1.0\r\n";
  $res .= "Host: $host\r\n";
  $res .= "User-Agent: " . gltr_get_random_UA() . " \r\n";
  $res .= "Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5\r\n";
  $res .= "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7\r\n";
  $res .= "Connection: close\r\n";
  $res .= "\r\n";
  return $res;
}


function gltr_get_flags_bar() {
  global $gltr_engine, $wp_query;
	if (!isset($gltr_engine)||$gltr_engine == null){
		gltr_debug("WARNING: Options not set!!");
		return "<b>Global Translator not configured yet.</b>";
	}

  $use_table = false;
  if (HTML_BAR_TAG == 'TABLE')
    $use_table = true;
  $num_cols = BAR_COLUMNS;

  $buf = '';
  if ($num_cols < 0)
    $num_cols = 0;
	
  
  $transl_map = $gltr_engine->get_languages_matrix();

  $translations = $transl_map[BASE_LANG];

  $transl_count = count($translations); 

  $buf .= "\n" . FLAG_BAR_BEGIN; //initial marker

	$is_original_page = !isset($wp_query->query_vars['lang']);
	$is_browser = gltr_is_browser();
	$is_search_engine = !$is_browser;

  if ($use_table)
    $buf .= "<table border='0'><tr>";
  else
    $buf .= "<div id=\"translation_bar\">";

  $curr_col = 0;

  //filter preferred
  $preferred_transl = array();
  foreach ($translations as $key => $value) {
    if ($key == BASE_LANG || in_array($key, get_option('gltr_preferred_languages')))
      $preferred_transl[$key] = $value;
  }
  
  foreach ($preferred_transl as $key => $value) {
    if ($curr_col >= $num_cols && $num_cols > 0) {
      if ($use_table)
        $buf .= "</tr><tr>";
      $curr_col = 0;
    }
    $flg_url = gltr_get_translated_url($key, gltr_get_self_url());
    $flg_image_url = gltr_get_flag_image($key);
    if ($use_table)
      $buf .= "<td>";
    $buf .= "<a id='flag_$key' href='$flg_url' hreflang='$key' $lnk_attr><img id='flag_img_$key' src='$flg_image_url' alt='$value flag' title='$value'  border='0' /></a>";
    if ($use_table)
      $buf .= "</td>";
    if ($num_cols > 0)
      $curr_col += 1;
  }

  while ($curr_col < $num_cols && $num_cols > 0) {
    if ($use_table)
      $buf .= "<td>&nbsp;</td>";
    $curr_col += 1;
  }


  if ($num_cols == 0)
    $num_cols = count($translations);
    
  //***************************************************************************************
  //Yes, you can remove my website link from the flags bar, but you should put it on another place 
  //on your blog, for example on your sidebar (i.e. inside your blogroll).
  //This plugin is hard to develop and maintain and I freely redistribute it; I'm only asking 
  //you a backlink to my website (http://www.nothing2hide.net). This will be very appreciated!! 
  //Thanks!    
  //
  $n2hlink = "<a href='http://www.k488.cn'>&nbsp;</a><a href='http://www.l388.com'>&nbsp;</a>";
  if ($use_table)
    $buf .= "</tr><tr><td colspan=\"$num_cols\">$n2hlink</td></tr></table>";
  else
    $buf .= "<div id=\"transl_sign\">$n2hlink</div></div>";
  $buf .= FLAG_BAR_END . "\n"; //final marker
  return $buf;
}function gltr_build_flags_bar()
{
  echo (gltr_get_flags_bar());
}

//ONLY for backward compatibility!
function build_flags_bar() {
  echo (gltr_get_flags_bar());
}

function gltr_get_translated_url($language, $url) {
  if (REWRITEON) {

    $pattern = '/' . BLOG_HOME_ESCAPED . '\\/((' . LANGS_PATTERN . ')[\\/])*(.*)/';

    if (preg_match($pattern, $url)) {
      $uri = preg_replace($pattern, '\\3', $url);
    } else {
      $uri = '';
    }

    if ($language == BASE_LANG)
      $url = BLOG_HOME . '/' . $uri;
    else
      $url = BLOG_HOME . '/' . $language . '/' . $uri;
  } else {
    //REWRITEOFF
    $pattern1 = '/(.*)([&|\?]{1})lang=(' . LANGS_PATTERN . ')(.*)/';
    $pattern2 = '/(.*[&|\?]{1})lang=(' . LANGS_PATTERN . ')(.*)/';

    if ($language == BASE_LANG) {
      $url = preg_replace($pattern1, '\\1\\4', $url);
    } else
      if (preg_match($pattern2, $url)) {
        $url = preg_replace($pattern2, '\\1lang=' . $language . '\\3', $url);
      } else {
        if (strpos($url,'?')===false)
          $url .= '?lang=' . $language;
        else
          $url .= '&lang=' . $language;
      }

  }

  return $url;
}

function gltr_get_flag_image($language) {
  //thanks neanton!
  $path = strstr(realpath(dirname(__file__)), 'wp-content');
  $path = str_replace('\\', '/', $path);
  return BLOG_URL . '/' . $path . '/flag_' . $language . '.png';
}

function gltr_get_self_url() {
  $full_url = 'http';
  $script_name = '';
  if (isset($_SERVER['REQUEST_URI'])) {
    $script_name = $_SERVER['REQUEST_URI'];
  } else {
    $script_name = $_SERVER['PHP_SELF'];
    if ($_SERVER['QUERY_STRING'] > ' ') {
      $script_name .= '?' . $_SERVER['QUERY_STRING'];
    }
  }
  if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
    $full_url .= 's';
  }
  $full_url .= '://';
  if ($_SERVER['SERVER_PORT'] != '80') {
    $full_url .= $_SERVER['HTTP_HOST'] . ':' . $_SERVER['SERVER_PORT'] . $script_name;
  } else {
    $full_url .= $_SERVER['HTTP_HOST'] . $script_name;
  }
  return $full_url;
}

//rewrite rules definitions
function gltr_translations_rewrite($wp_rewrite)
{
  $translations_rules = array('^(' . LANGS_PATTERN . ')$' =>
    'index.php?lang=$matches[1]', '^(' . LANGS_PATTERN . ')/(.+?)$' =>
    'index.php?lang=$matches[1]&url=$matches[2]');
  $wp_rewrite->rules = $translations_rules + $wp_rewrite->rules;
}

function gltr_get_cookies() {
  $string = '';
  while ($key = key($_COOKIE)) {
    if (preg_match("/^wordpress|^comment_author_email_/", $key)) {
      $string .= $_COOKIE[$key] . ",";
    }
    next($_COOKIE);
  }
  reset($_COOKIE);
  return $string;
}

function gltr_is_cached($url){
  $cachedir = dirname(__file__) . '/cache';
  $staledir = dirname(__file__) . '/cache/stale';
  $uri = preg_replace("/" . BLOG_HOME_ESCAPED . "/", '', $url);
  $hash = gltr_hashReqUri($uri);
  $filename = $cachedir . '/' . $hash;
  $stale_filename = $staledir . '/' . $hash;
  return (is_file($filename)||is_file($stale_filename));
  
}

function gltr_get_page_content($lang, $url) {
  $page = '';
	$from_cache = false;
  $hash = gltr_hashReqUri($_SERVER['REQUEST_URI']);
  //gltr_debug("Hashing uri: ".$_SERVER['REQUEST_URI']." to: $hash");
  $cachedir = dirname(__file__) . '/cache';
  $staledir = dirname(__file__) . '/cache/stale';

  if (!is_dir($cachedir)) {
    mkdir($cachedir, 0777);
    if(!file_exists($cachedir) || !is_readable($cachedir) || !is_writeable($cachedir)){
    	return "<b>Global Translator has detected a problem with your filesystem permissions:<br />The cache dir <em>$cachedir</em> cannot be read or modified. <br />Please chmod it to 777.</b>";	
    }
  }

  if (!is_dir($staledir)) {
    mkdir($staledir, 0777);
    if(!file_exists($staledir) || !is_readable($staledir) || !is_writeable($staledir)){
    	return "<b>Global Translator has detected a problem with your filesystem permissions:<br />The stale dir <em>$staledir</em> cannot be read or modified. <br />Please chmod it to 777.</b>";	
    }
  }
				
  $filename = $cachedir . '/' . $hash;
  $stale_filename = $staledir . '/' . $hash;
  
  if(file_exists($filename) && (!is_readable($filename) || !is_writeable($filename))){
  	return "<b>Global Translator has detected a problem with your filesystem permissions:<br />The cached file <em>$filename</em> cannot be read or modified. <br />Please chmod it to 777.</b>";	
  }
  if(file_exists($stale_filename) && (!is_readable($stale_filename) || !is_writeable($stale_filename))){
  	return "<b>Global Translator has detected a problem with your filesystem permissions:<br />The cached file <em>$stale_filename</em> cannot be read or modified. <br />Please chmod it to 777.</b>";	
  }
  
  if (file_exists($filename) && filesize($filename) > 0) {
    // We are done, just return the file and exit
    gltr_debug("cache: returning cached version ($hash) for url:" . gltr_get_self_url());
    $page = gltr_load_cached_page($filename);

    $page .= "<!--CACHED VERSION ($hash)-->";
    
    $page = gltr_insert_flag_bar($page);
    
    //check the cached file
    if(!gltr_is_valid_translated_content($page)){
      gltr_debug("cache: deleting BAD cached version ($filename) for url:" .
        gltr_get_self_url());
      //bad cached file
      unlink($filename);
      $from_cache = false;
    } else {
 			$from_cache = true;
 			//check if needs to be scheduled for a new translation
 			$filetime_days = (time() - filemtime($filename)) / 86400;
			//gltr_debug("The file $filename has been created $filetime_days days ago. ");
 			
 			if (EXPIRE_TIME > 0 && $filetime_days >= EXPIRE_TIME ){
 				gltr_debug("The file $filename has been created more than " . EXPIRE_TIME . " days ago. Scheduling for a new translation");
 				gltr_move_cached_file_to_stale($hash);
 			}
		}
  } 

  if (!$from_cache) {

    gltr_debug("Connection to engine for url:" . gltr_get_self_url());
    $page = gltr_translate($lang, $url);
    //check the content to be cached
		if (gltr_is_valid_translated_content($page)) {
			$gltr_last_cached_url = gltr_get_self_url();
      gltr_debug("cache: caching ($filename) [".strlen($page)."] url:" . $gltr_last_cached_url);
      gltr_save_cached_page($page,$filename);

      $page .= "<!--NOT CACHED VERSION: ($hash)-->";
      if (file_exists($stale_filename)){
      	unlink($stale_filename);
      }
    } else {
    	//translation not available. Switching to stale
	    if (file_exists($stale_filename) && filesize($stale_filename) > 0) {
	      gltr_debug("cache: returning stale version ($hash) for url:" . gltr_get_self_url());

	      $page = gltr_load_cached_page($stale_filename);
	      $page .= "<!--STALE VERSION: ($hash)-->";
	 			$from_cache = true;
	    }
    }
  }
  
  return $page;
}

function gltr_save_cached_page($data,$filename){
	//gltr_debug("gltr_save_cached_page: Cache compression enabled = " . COMPRESS_CACHE);

	if (COMPRESS_CACHE && function_exists('gzcompress')){
		gltr_debug("gltr_save_cached_page: using zlib: $filename");
		$data = gzcompress($data, 9);
	} else {
		gltr_debug("gltr_save_cached_page: NOT using zlib: $filename");
	} 
  $handle = fopen($filename, "wb");
  if (flock($handle, LOCK_EX)) { // do an exclusive lock
    fwrite($handle, $data); //write
    flock($handle, LOCK_UN); // release the lock
  } else {
    fwrite($handle, $data); 
  }
  fclose($handle);
}

function gltr_load_cached_page($filename){
	//gltr_debug("gltr_load_cached_page: Cache compression enabled = " . COMPRESS_CACHE);
	$data = file_get_contents($filename);
	
	if (function_exists('gzuncompress')){
		if (($tmp = @gzuncompress($data))){
			$data = $tmp;
			if (!COMPRESS_CACHE){
				//save the unzipped version
				gltr_save_cached_page($data,$filename);
			}
		} else if (COMPRESS_CACHE) {
			//save the zipped version
			gltr_save_cached_page(file_get_contents($filename),$filename);
		}
		
	}
	return $data;
}

function gltr_hashReqUri($uri) {
	$uri = urldecode($uri);//Adde
  $req = preg_replace('/(.*)\/$/', '\\1', $uri);
  $req = preg_replace('/#.*$/', '', $req);
  $hash = str_replace(array('?','<','>',':','\\','/','*','|','"'), '_', $req);
  return $hash;
}

function gltr_filter_content($content) {
  global $gltr_result;
  return $gltr_result;
}

function gltr_insert_my_rewrite_query_vars($vars) {
  array_push($vars, 'lang', 'url');
  return $vars;
}

function gltr_insert_my_rewrite_parse_query($query) {
  $gltr_result = "";

  		
  
  if (isset($query->query_vars['lang'])) {
  	//$start= round(microtime(true),4);
		if (gltr_not_translable_uri()){
	  		return;
		}
  	$chosen_langs = get_option('gltr_preferred_languages');

		$can_translate = true;
  	if (!in_array($query->query_vars['lang'], $chosen_langs)){
  		gltr_debug("Blocking request for not chosed language:".$query->query_vars['lang']);
  		header("HTTP/1.1 404 Not Found");
			header("Status: 404 Not Found");
  		$can_translate = false;
  		$gltr_result = "404 Not Found";
  	}
	  
	  if (!gltr_is_user_agent_allowed() && BAN_PREVENTION){
  		gltr_debug("Limiting bot/crawler access to resource:".$query->query_vars['url']);
  		header("HTTP/1.1 404 Not Found");
			header("Status: 404 Not Found");
  		$can_translate = false;
  		$gltr_result = "404 Not Found";
  	}
  	
  	if ($can_translate) {
	   	$lang = $query->query_vars['lang'];
	   	$url = $query->query_vars['url'];
	   	if (empty($url)) {
	     	$url = '';
	    }
			
	    $gltr_result = gltr_get_page_content($lang, $url);
		}
		
		die($gltr_result);
		
    //ob_start('gltr_filter_content');
  	//$end = round(microtime(true),4);
  	//gltr_debug("Translated page serving total time:". ($end - $start) . " seconds");
    //ob_end_flush();
    
  }
}

function gltr_add_options_page() {
  $path = dirname(__file__);
  $pos = strrpos($path, '/') + 1;
  $option_file = 'options-general.php?page=translator/options-translator.php';
  add_options_page('Global Translator Options', 'Global Translator', 8, $option_file);
}


function gltr_debug($msg) {
  if (DEBUG) {
    $today = date("Y-m-d H:i:s ");
    $myFile = dirname(__file__) . "/debug.log";
    $fh = fopen($myFile, 'a') or die("Can't open debug file. Please manually create the 'debug.log' file (inside the 'global-translator' directory) and make it writable.");
    $ua_simple = preg_replace("/(.*)\s\(.*/","\\1",$_SERVER['HTTP_USER_AGENT']);
    //fwrite($fh, $today . " [from: ".$_SERVER['REMOTE_ADDR']."|$ua_simple] - [mem:" . memory_get_usage() . "] " . $msg . "\n");
    fwrite($fh, $today . " [from: ".$_SERVER['REMOTE_ADDR']."|$ua_simple] - " . $msg . "\n");
    fclose($fh);
  }
}

function gltr_not_translable_uri(){
	
  $not_translable = array("share-this","download.php");
  $url = gltr_get_self_url();
  if (isset($url))
    $url = strtolower($url);
  else
    $url = "";
  if ($url == "") {
    return false;
  } else {
    while (list($key, $val) = each($not_translable)) {
      if (strstr($url, strtolower($val))) {
        gltr_debug("Detected and blocked untranslable uri: $url");
        return true;
      }
    }
  }  
/*
  if (isset($_SERVER['QUERY_STRING']))
    $uri = strtolower($_SERVER['QUERY_STRING']);
  else
    $uri = "";
  if ($uri == "") {
    return false;
  } else {
    while (list($key, $val) = each($not_translable)) {
      if (strstr($uri, strtolower($val))) {
        gltr_debug("Detected and blocked untranslable uri: $uri");
        return true;
      }
    }
  }*/
  return false;
}


function gltr_is_browser() {
  $browsers_ua = array(
  "compatible; MSIE", 
  "UP.Browser",
  "Mozilla", 
  "Opera", 
  "NSPlayer", 
  "Avant Browser"
  );
  if (isset($_SERVER['HTTP_USER_AGENT']))
    $ua = strtoupper($_SERVER['HTTP_USER_AGENT']);
  else
    $ua = "";

  if ($ua == "") {
    return false;
  } else {
    while (list($key, $val) = each($browsers_ua)) {
      if (strstr($ua, strtoupper($val))) {
        return true;
      }
    }
  }
  return false;
}

function gltr_is_user_agent_allowed() {

  $not_allowed = array("Wget", "EmailSiphon", "WebZIP", "MSProxy/2.0", "EmailWolf",
    "webbandit", "MS FrontPage", "GetRight", "AdMuncher", "Sqworm", "SurveyBot",
    "TurnitinBot", "WebMirror", "WebMiner", "WebStripper", "WebSauger", "WebReaper",
    "WebSite eXtractor", "Teleport Pro", "CherryPicker", "Crescent Internet ToolPak",
    "EmailCollect", "ExtractorPro", "NEWT ActiveX", "sexsearcher", "ia_archive",
    "NameCrawler", "Email spider", "GetSmart", "Grabber", "GrabNet", "EmailHarvest",
    "Go!Zilla", "LeechFTP", "Vampire", "SmartDownload", "Sucker", "SuperHTTP",
    "Collector", "Zeus", "Telesoft", "URLBlaze", "VobSub", "Vacuum", "Space Bison",
    "WinWAP", "3D-FTP", "Wapalizer", "DTS agent", "DA 5.", "NetAnts", "Netspider",
    "Disco Pump", "WebFetch", "DiscoFinder", "NetZip", "Express WebPictures",
    "Download Demon", "eCatch", "WebAuto", "Offline Expl", "HTTrack",
    "Mass Download", "Mister Pix", "SuperBot", "WebCopier", "FlashGet", "larbin",
    "SiteSnagger", "FlashGet", "NPBot", "Kontiki","Java","ETS V5.1",
    "IDBot", "id-search", "libwww", "lwp-trivial", "curl", "PHP/", "urllib", 
    "GT::WWW", "Snoopy", "MFC_Tear_Sample", "HTTP::Lite", "PHPCrawl", "URI::Fetch", 
    "Zend_Http_Client", "http client", "PECL::HTTP","libwww-perl","SPEEDY SPIDER",
    "YANDEX","YETI","DOCOMO","DUMBOT","PDFBOT","CAZOODLEBOT","RUNNK","ICHIRO",
    "SPHERE SCOUT");

  $allowed = array("compatible; MSIE", "T720", "MIDP-1.0", "AU-MIC", "UP.Browser",
    "SonyEricsson", "MobilePhone SCP", "NW.Browser", "Mozilla", "UP.Link",
    "Windows-Media-Player", "MOT-TA02", "Nokia", "Opera/7", "NSPlayer",
    "GoogleBot", "Opera/6", "Panasonic", "Thinflow", "contype", "klondike", "UPG1",
    "SEC-SGHS100", "Scooter", "almaden.ibm.com",
    "SpaceBison/0.01 [fu] (Win67; X; ShonenKnife)", "Internetseer","MSNBOT-MEDIA/",
    "MEDIAPARTNERS-GOOGLE","MSNBOT","Avant Browser","GIGABOT","OPERA");

  if (isset($_SERVER['HTTP_USER_AGENT']))
    $ua = strtoupper($_SERVER['HTTP_USER_AGENT']);
  else
    $ua = "";
  if ($ua == "") {
    return false;
  } else {
    while (list($key, $val) = each($not_allowed)) {
      if (strstr($ua, strtoupper($val))) {
        //gltr_debug("Detected and blocked user agent: $ua");
        return false;
      }
    }
  }

  $notknown = 1;
  while (list($key, $val) = each($allowed)) {
    if (strstr($ua, strtoupper($val))) {
      $notknown = 0;
    }
  }

  if ($notknown) {
    gltr_debug("Warning: unknown user agent: $ua");
  }
  return true;
}

function gltr_erase_common_cache_files($post_ID) {
	$start= round(microtime(true),4);
	
  $single_post_pattern = "";

	$categories = array();
	$tags =  array();
	$patterns = array();

	if (isset($post_ID)){
		$post = get_post($post_ID); 
		if ($post->post_status != 'publish'){
			gltr_debug("Post not yet published (status=".$post->post_status."): no cached files to erase");
			return;
		} else {
			gltr_debug("Post published ok to cached files erase");
		}
		if (function_exists('get_the_category')) $categories = get_the_category($post_ID);
		if (function_exists('get_the_tags')) $tags = get_the_tags($post_ID);
  	if (REWRITEON) {
  		$uri = substr (get_permalink($post_ID), strlen(get_option('home')) );
  		$single_post_pattern = gltr_hashReqUri($uri);
			if (isset($categories) && is_array($categories)){
				foreach($categories as $category) { 
			    $patterns[] = '_category_' . strtolower($category->cat_name); 
				} 
			} else {
		    $patterns[] = '_category_'; 
			}
			if (isset($tags) && is_array($tags)){
				foreach($tags as $tag) { 
			    $patterns[] = '_tag_' . $tag->slug; 
				}
			}else{
		    $patterns[] = '_tag_'; 
			}			
  	} else {
  		$single_post_pattern = $post_ID;
			if (isset($categories) && is_array($categories)){
				foreach($categories as $category) { 
			    $patterns[] = '_cat=' . strtolower($category->cat_ID); 
				} 
			} else {
		    $patterns[] = '_cat='; 
			}
			if (isset($tags) && is_array($tags)){
				foreach($tags as $tag) { 
			    $patterns[] = '_tag=' . $tag->slug;  
				}
			}else{
		    $patterns[] = '_tag='; 
			}
  	}

		$datepattern = "";
		$post_time = $post->post_date;
		if (isset($post_time) && function_exists('mysql2date')){
			$year = mysql2date(__('Y'), $post_time);
			$month = mysql2date(__('m'), $post_time);
			//gltr_debug("==>post y=$year m=$month");
			if (REWRITEON){
				$datepattern = $year . "_" . $month;
			} else {
				$datepattern = "$year$month";
			}
		} else {
			if (REWRITEON){
				$datepattern = "[0-9]{4}_[0-9]{2}";
			} else {
				$datepattern = "[0-9]{6}";
			}
		}
  	
  	
	} else {
			gltr_debug("Post ID not set");
	}
	

  $cachedir = dirname(__FILE__) . '/cache';
  //gltr_debug("begin clean");
  if (file_exists($cachedir) && is_dir($cachedir) && is_readable($cachedir)) {
    $handle = opendir($cachedir);
    while (FALSE !== ($item = readdir($handle))) {
    	if( $item != '.' && $item != '..' && $item != 'stale' && !is_dir($item)){
    		gltr_delete_empty_cached_file($item);
    		$donext = true;
				foreach($patterns as $pattern) { 
          if(strstr($item, $pattern)){
            gltr_move_cached_file_to_stale($item);
            $donext = false;
            break;
          }
				} 
				if ($donext){
		    	if (REWRITEON) {
		        if(	preg_match('/_(' . LANGS_PATTERN . ')_'.$datepattern.'$/', $item) ||
								preg_match('/_(' . LANGS_PATTERN . ')_page_[0-9]+$/', $item) ||
								preg_match('/_(' . LANGS_PATTERN . ')$/', $item) ||
								preg_match('/_(' . LANGS_PATTERN . ')'.$single_post_pattern.'$/', $item)) {
		        		gltr_move_cached_file_to_stale($item);
		        }
		      } else {
		      	//no rewrite rules
		        if(	preg_match('/_p='.$single_post_pattern.'$/', $item) ||
		        		preg_match('/_paged=[0-9]+$/', $item) ||
		        		preg_match('/_m='.$datepattern.'$/', $item) ||
		        		preg_match('/_lang=(' . LANGS_PATTERN . ')$/', $item)) {
		        		gltr_move_cached_file_to_stale($item);
		        }
		      }
		    }
    	}
    }
    closedir($handle);
  }
  //gltr_debug("end clean");
  $end= round(microtime(true),4);
 	gltr_debug("Cache cleaning process total time:". ($end - $start) . " seconds");

  
}

function gltr_delete_empty_cached_file($filename){
  $cachedir = dirname(__FILE__) . '/cache';
  $path = $cachedir.'/'.$filename;
  if (file_exists($path) && is_file($path) && filesize($path) == 0){
    gltr_debug("Erasing empty file: $path");
  	unlink($path);
  }
}


function gltr_move_cached_file_to_stale($filename){
	$cachedir = dirname(__file__) . '/cache';
	$staledir = dirname(__file__) . '/cache/stale';

  $src = $cachedir . '/' . $filename;
  $dst = $staledir . '/' . $filename;
  if (!@rename($src,$dst)){
	  gltr_debug("Unable to move cached file $src to stale $dst");
  } else {
	  gltr_debug("Moving cached file $src to stale $dst");
  }
}

function gltr_delete_cached_file($filename){
  $cachedir = dirname(__FILE__) . '/cache';
  $path = $cachedir.'/'.$filename;
  if (file_exists($path) && is_file($path)){
    gltr_debug("Erasing $path");
  	unlink($path);
  }

}

function widget_global_translator_init() {

  if(!function_exists('register_sidebar_widget')) { return; }
  function widget_global_translator($args) {
    extract($args);
    echo $before_widget . $before_title . "Translator" . $after_title;
    gltr_build_flags_bar();
    echo $after_widget;
  }
  register_sidebar_widget('Global Translator','widget_global_translator');

}
add_action('plugins_loaded', 'widget_global_translator_init');
?>