<?php

//admin option
include_once('admin-option/theme-option.php');

//nav menu
register_nav_menus(array(
	'top'=>'头部导航',
	'bottom'=>'底部次导航'
));

class Travel_Walker_Nav_Menu extends Walker_Nav_Menu{
	
	function start_el(&$output, $item, $depth, $args) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = ' class=" no2_head_left_li ' . esc_attr( $class_names ) . '"';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
		$id = strlen( $id ) ? ' id="' . esc_attr( $id ) . '"' : '';
                

		$output .= $indent . '<div' . $id . $value . $class_names .'>';

		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

	function end_el(&$output, $item, $depth) {
		$output .= "</div>\n<div class=\"no2_li\"><img src=\"".get_bloginfo('template_url')."/images/no2/yin.gif\" /></div>\n";
	}
}

class Bottom_Walker_Nav_Menu extends Walker_Nav_Menu {
		function end_el(&$output, $item, $depth) {
		$output .= "</li><li class=\"foot_shu2\">|</li>\n";
	}
}


//add post meta
add_action('add_meta_boxes','web589_travel_meta_box');
function web589_travel_meta_box(){
	add_meta_box('travel_meta','<b>旅游信息</b>','web589_travel_meta','post','advanced');
	add_meta_box('template_meta','文章模板','web589_singular_tenplate_meta','post','side','high');
}
function web589_travel_meta(){
	include_once('includes/meta_box_form.php');
}
function web589_singular_tenplate_meta(){
	echo '<select name="singular_template" id="singular_template">';
	$meta=get_post_meta(get_the_ID(),'_web589_travel_metas',true);
	switch($meta['template']){
		case 'normal': $check1='selected'; $check2=''; break;
		case 'travel': $check1=''; $check2='selected'; break;
	}
	echo '<option value="normal" '.$check1.'>普通模板';
	echo '<option value="travel" '.$check2.'>旅游模板';
	echo '</select>';
}

add_action('save_post','web589_save_post');
function web589_save_post($id){
	$val=array(
		'price'=>$_POST['price'],
		'market'=>$_POST['market'],
		'city'=>$_POST['city'],
		'date'=>$_POST['date'],
		'pay'=>$_POST['pay'],
		'agency'=>$_POST['agency'],
		'days'=>$_POST['days'],
		'discount'=>$_POST['discount'],
		'template'=>$_POST['singular_template']
	);
	if($_POST['save_travel_postmeta']=='on') update_post_meta($id,'_web589_travel_metas',$val);
}


//thumbnail
if ( function_exists( 'add_theme_support' ) ) {
	add_theme_support( 'post-thumbnails' );
		if ( function_exists( 'add_image_size' ) ) { 
		/* 	add_image_size('home',160,160,true); */
		}
}
function web589_first_thumbnail($size="thumbnail"){
	global $post;
	$args=array('post_type'=>'attachment','post_mime_type'=>'image','post_parent'=>$post->ID,'order'=>'asc');
	$images=get_children($args);
	if(has_post_thumbnail()) return get_the_post_thumbnail($post->ID,$size);
	else if($images){
		$attachment_id=key($images);
		return wp_get_attachment_image($attachment_id,$size);
	}
	else {
		$preg="/(<img )([^>]*)(>)/"; 
		$content=$post->post_content;
		preg_match($preg,$content,$img);
		return $img[0];
	}
}
function web589_thumbnail($size="thumbnail",$num=1){
	global $post;
	$args=array('post_type'=>'attachment','post_mime_type'=>'image','post_parent'=>$post->ID,'order'=>'asc');
	$images=get_children($args);
	if(has_post_thumbnail() && $num==1) $img[]=get_the_post_thumbnail($post->ID,$size);
	else if($images){
		foreach($images as $attachment_id=>$res){
			$img[]=wp_get_attachment_image($attachment_id,$size);
		}
	}
	else {
		$preg="/(<img )([^>]*)(>)/"; 
		$content=$post->post_content;
		preg_match_all($preg,$content,$matches);
		foreach($matches[2] as $match){
			$img[]=$match;
		}
	}
	return $img;
}
function web589_thumbnail_src($size='thumbnail',$num=1){
	global $post;
	$args=array('post_type'=>'attachment','post_mime_type'=>'image','post_parent'=>$post->ID,'order'=>'asc');
	$images=get_children($args);
	if(has_post_thumbnail() && $num==1){
		$srcs=wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),$size);
		$src[]=$srcs[0];
	}
	else if($images){
		foreach($images as $attachment_id=>$res){
			$srcs=wp_get_attachment_image_src($attachment_id,$size);
			$src[]=$srcs[0];
		}
	}
	else{
		$preg="/(src=\")([^\"]*)(\")/";
		preg_match_all($preg,$post->post_content,$matches);
		foreach($matches[2] as $match){
			$src[]=$match;
		}
	}
	return $src;
}


//travel data short code
add_shortcode('travel','web589_travel_data');
function web589_travel_data($atts){
	extract(shortcode_atts(array(
		'name'=>'',
		'content'=>'',
		'color'=>'',
		),$atts)
	);
	switch($color){
		case '1': $class1='class="line2_day1"'; $class2='class="line2_left1"'; $class3='class="line2_left1"'; break;
		case '2': $class1='class="line2_day2"'; $class2='class="line2_left2"'; $class3='class="line2_left2"'; break;
		default: $class1='class="line2_day"'; $class2=''; $class3='class="line2_left"'; break;
	}
	$pre='<div '.$class1.'>';
	$name='<div '.$class3.' '.$class2.'>'.$name.'</div>';
	$content='<div class="line2_right">'.$content.'</div>';
	$end='</div>';
	return $pre.$name.$content.$end;
}
//travel single filter images
add_filter('the_content','web589_travel_filter_img');
function web589_travel_filter_img($content){
	$meta=get_post_meta(get_the_ID(),'_web589_travel_metas',true);
	if(is_single() && $meta['template']=='travel'){
		$content=preg_replace('/<img .*?>/','',$content);
	}
	return $content;
}


//post views
function web589_views($user='together'){
	web589_update_views($user);
	$views=get_post_meta(get_the_ID(),'_web589_post_views',true);
	return $views;
}

function web589_update_views($user='together'){
	$views= get_post_meta(get_the_ID(),'_web589_post_views',true) ? get_post_meta(get_the_ID(),'_web589_post_views',true) : 0;
	switch($user){
		case 'visitor':
		if(!is_user_logged_in()) update_post_meta(get_the_ID(),'_web589_post_views',++$views); 
		break;
		case 'user':
		if(is_user_logged_in()) update_post_meta(get_the_ID(),'_web589_post_views',++$views);
		break;
		case 'together':
		update_post_meta(get_the_ID(),'_web589_post_views',++$views);
		break;
	}
}


//crumbs
function web589_crumbs($sep='>>',$home='首页'){
	$par=web589_get_parrents($sep);
	if(!empty($par)){
		$num=count($par);
		$m=1;
		echo '<a href="'.get_bloginfo('url').'">'.$home.'</a>'.$sep;
		foreach($par as $link=>$name){
			if($m==$num) echo $name;
			else echo '<a href="'.$link.'">'.$name.'</a>'.$sep;
			$m++;
		}
	}
}
function web589_get_parrents($sep='>'){
	if(is_category()){
		$par=get_ancestors(get_query_var('cat'),'category');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$id=$par[$j];
			$array[get_category_link($id)]=get_cat_name($id);
		}
		$array[get_category_link(get_query_var('cat'))]=get_cat_name(get_query_var('cat'));
	}
	if(is_page()){
		$par=get_ancestors(get_the_ID(),'page');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$id=$par[$j];
			$page=get_page($id);
			$array[get_page_link($id)]=$page->post_title;
		}
		$cur_page=get_page(get_the_ID());
		$array[get_page_link(get_the_ID())]=$cur_page->post_title;		
	}
	if(is_single()){
		$cats=get_the_category();
		foreach($cats as $cat){
			foreach($cats as $child){
				if(!cat_is_ancestor_of($cat,$child)) $id=$cat->cat_ID;
			}
		}		
		$par=get_ancestors($id,'category');
		$num=count($par);
		for($i=$num;$i>=1;$i--){
			$j=$i-1;
			$p_id=$par[$j];
			$array[get_category_link($p_id)]=get_cat_name($p_id);
		};
		$array[get_category_link($id)]=get_cat_name($id);						
		$array[get_permalink()]=get_the_title();
	}
	if(is_tag()){
		$tag=get_tag(get_query_var('tag_id'));
		$array[]=$tag->name;
	}
	if(is_day() ||is_month() ||is_year()){
		$array[]=wp_title('',false);
	}	
	return $array;
}


//paging
function web589_paging(){
	$page=web589_paging_data();	
	
	if( $page['pages']<=1 ) return;
	
	if( $page['cur']==1 ) $home='<a disabled="disabled" >&lt;&lt;</a>';	
	else $home='<a id="p_home" href="'.$page[1].'" style="margin-right:5px;">&lt;&lt;</a>';
	
	if( $page['cur']==$page['pages'] ) $end='<a disabled="disabled" >&gt;&gt;</a>';
	else $end='<a id="p_end" href="'.$page[$page['pages']].'" style="margin-right:5px;">&gt;&gt;</a>';
	
	if( $page['cur']==1 ) $pre='<a disabled="disabled" style="margin-right:5px;">&lt;</a>';
	else $pre='<a id="p_pre" href="'.$page[($page['cur']-1)].'" style="margin-right:5px;">&lt;</a>';
	
	if( $page['cur']==$page['pages'] ) $next='<a disabled="disabled" style="margin-right:5px;">&gt;</a>';
	else $next='<a id="p_next" href="'.$page[($page['cur']+1)].'" style="margin-right:5px;">&gt;</a>';
	
	if($page['pages']<=5){
		for($i=1;$i<=$page['pages'];$i++){
			if($i==$page['cur']) $num.='<span style="margin-right:5px;font-weight:Bold;color:red;">'.$i.'</span>';
			else $num.='<a href="'.$page[$i].'" style="margin-right:5px;">'.$i.'</a>';
		}
	}
	else{
		$cur=$page['cur'];
		if( ($cur-2)>1 ) $num.='<span class="ellipsis">...</span>';
		
		
		switch($cur){
			case 1: $start=$cur; $last=$cur+4; break;
			case 2: $start=$cur-1; $last=$cur+3; break;
			case ($page['pages']-1): $start=$cur-3; $last=$cur+1; break;
			case ($page['pages']): $start=$cur-4; $last=$cur; break;
			default: $start=$cur-2; $last=$cur+2; break;
		}
		for($j=$start;$j<=$last;$j++){
			if($j==$cur) $num.='<span style="margin-right:5px;font-weight:Bold;color:red;">'.$j.'</span>';
			else $num.='<a href="'.$page[$j].'" style="margin-right:5px;">'.$j.'</a>';
		}
		
		
		if(($cur+2)<$page['pages']) $num.='<span class="ellipsis" >...</span>';
	}
	
	echo $home.$pre.$num.$next.$end;
}

function web589_paging_data(){
	$page['sum']=web589_count_posts_num();
	$page['pages']=ceil($page['sum']/get_option('posts_per_page'));
	$page['cur']=get_query_var('paged') ? get_query_var('paged'):1;
	for($i=1;$i<=$page['pages'];$i++){
		$page[$i]=get_pagenum_link($i);
	}
	return $page;
}

//count posts num
function web589_count_posts_num(){
	global $wpdb;
	if( is_home() || is_front_page() ){
		query_posts(array('ignore_sticky_posts'=>true,'posts_per_page'=>-1));	
	}
	if(is_category()){
		query_posts(array('cat'=>get_query_var('cat'),'ignore_sticky_posts'=>true,'posts_per_page'=>-1));
	}
	if(is_tag()){
		query_posts(array('tag_id'=>get_query_var('tag_id'),'ignore_sticky_posts'=>true,'posts_per_page'=>-1));	
	}
	if(is_date()){
		query_posts(array('year'=>get_query_var('year'),'monthnum'=>get_query_var('monthnum'),'w'=>get_query_var('w'),'day'=>get_query_var('day'),'hour'=>get_query_var('hout'),'minute'=>get_query_var('minute'),'second'=>get_query_var('second'),'ignore_sticky_posts'=>true,'posts_per_page'=>-1));		
	}
	if(is_author()){
		query_posts(array('author'=>get_query_var('author'),'ignore_sticky_posts'=>true,'posts_per_page'=>-1));	
	}
	if(is_search()){
		query_posts(array('s'=>get_query_var('s'),'ignore_sticky_posts'=>true,'posts_per_page'=>-1));			
	}
	$i=0;
	while(have_posts()){
		the_post();
		$i++;
	}		
	wp_reset_query();
	return $i;
}