﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ESBasic;

namespace ESFramework.Demos.DynamicGroup.Client
{
    public partial class EmotionForm : Form
    {
        public event CbSimpleInt EmotionClicked;

        public EmotionForm()
        {
            InitializeComponent();             
            this.EmotionClicked += delegate { };  
            this.faceEmotionBoard1.EmotionClicked += new CbSimpleInt(faceEmotionBoard1_EmotionClicked);
        }

        protected override void OnLostFocus(EventArgs e)
        {
            this.Visible = false;
            base.OnLostFocus(e);
        }

        public void Initialize()
        {
            List<Image> list = new List<Image>();
            string path = AppDomain.CurrentDomain.BaseDirectory + "\\Face\\";
            for (int i = 1; i <= 135; i++)
            {
                list.Add(Image.FromFile(string.Format("{0}{1}.gif", path, i)));
            }
            this.faceEmotionBoard1.Initialize(list);
            this.faceEmotionBoard1.Refresh();
        }

        void faceEmotionBoard1_EmotionClicked(int val)
        {
            this.EmotionClicked(val+1);
            this.Visible = false;
        }

        private void EmotionForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            this.Visible = false;
        }
    }
}
