﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ESBasic.Widget;
using ESBasic.Collections;
using ESFramework.Passive;
using ESBasic;
using ESPlus.Application.CustomizeInfo.Passive;
using ESPlus.Application.Group.Passive;
using ESFramework;
using ESFramework.Demos.DynamicGroup.Core;

namespace ESFramework.Demos.DynamicGroup.Client
{
    public partial class TextChatControl : UserControl
    {
        private EmotionForm emotionForm ;
        private string userID = "";
        private IGroupOutter groupOutter = null;        
        private string groupID;

        #region ButtonSend
        /// <summary>
        /// ButtonSend 用于设为AcceptButton
        /// </summary>
        public Button ButtonSend
        {
            get
            {
                return this.button_send;
            }
        } 
        #endregion

        public TextChatControl()
        {
            InitializeComponent();
            this.fontDialog1.ShowColor = true;
            this.emotionForm = new EmotionForm();            
            this.emotionForm.EmotionClicked += new ESBasic.CbSimpleInt(emotionForm_EmotionClicked);
            string path = AppDomain.CurrentDomain.BaseDirectory + "\\Face\\";
            this.agileRichTextBox_history.Initialize(new DefaultImagePathGetter(path ,".gif"));
            this.agileRichTextBox_send.Initialize(new DefaultImagePathGetter(path, ".gif"));                  
        }

        public void Initialize(string _userID, string _groupID, IGroupOutter _groupOutter)
        {
            this.emotionForm.Initialize();
            this.userID = _userID;
            this.groupID = _groupID;
            this.groupOutter = _groupOutter;
        }      

        void emotionForm_EmotionClicked(int imageID)
        {
            this.agileRichTextBox_send.InsertImage((uint)imageID, this.agileRichTextBox_send.TextLength);
            this.agileRichTextBox_send.Focus();
            this.agileRichTextBox_send.ScrollToCaret();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            this.emotionForm.Visible = !this.emotionForm.Visible;
            if (this.emotionForm.Visible)
            {
                Point pt = this.PointToScreen(this.toolStrip1.Location);
                this.emotionForm.Location = new Point(pt.X - this.emotionForm.Width / 2, pt.Y - this.emotionForm.Height + this.agileRichTextBox_history.Height);
            }
        }

        private void button_send_Click(object sender, EventArgs e)
        {
            bool containsForeignObject = false;
            SortedArray<int, uint> ary = this.agileRichTextBox_send.GetAllImage(out containsForeignObject);
            if (this.agileRichTextBox_send.Text.Trim() == "" && ary.Count == 0 && (!containsForeignObject))
            {
                return;
            }
            string text = "";
            
            this.agileRichTextBox_history.AppendRichText(string.Format("{0} {1}\n  ",this.userID, DateTime.Now) ,null,null,Color.DarkGreen);
            if (containsForeignObject)
            {
                this.agileRichTextBox_history.AppendRtf(this.agileRichTextBox_send.Rtf);// AppendRichText(this.agileRichTextBox_send.Text, ary, this.agileRichTextBox_send.Font, this.agileRichTextBox_send.ForeColor);
                text = this.agileRichTextBox_send.Rtf;
            }
            else
            {
                this.agileRichTextBox_history.AppendRichText(this.agileRichTextBox_send.Text, ary, this.agileRichTextBox_send.Font, this.agileRichTextBox_send.ForeColor);
                text = this.agileRichTextBox_send.Text;
            }

            TextChatContract contract = new TextChatContract(text, containsForeignObject, ary, this.agileRichTextBox_send.Font, this.agileRichTextBox_send.ForeColor);
            this.agileRichTextBox_history.AppendText("\n");
            this.agileRichTextBox_history.ScrollToCaret();
            this.agileRichTextBox_send.Clear();

            //发送消息给组好友
            this.groupOutter.Broadcast(this.groupID, GroupInformationTypes.GroupChat, ESBasic.Helpers.SerializeHelper.SerializeObject(contract), ActionTypeOnChannelIsBusy.Continue);            
        }     

        public void ShowOtherTextChat(string userID, TextChatContract contract)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new CbGeneric<string, TextChatContract>(this.ShowOtherTextChat), userID, contract);
            }
            else
            {
                if (userID != this.userID)
                {                   
                    
                    this.agileRichTextBox_history.AppendRichText(string.Format("{0} {1}\n  ", userID, DateTime.Now), null, null, Color.DarkGreen);
                    if (contract.ContainsForeignObject)
                    {
                        this.agileRichTextBox_history.AppendRtf(contract.Text);
                        
                    }
                    else
                    {
                        this.agileRichTextBox_history.AppendRichText(contract.Text, contract.LocalEmotionArray, contract.Font, contract.ForeColor);                        
                    }
                    
                    this.agileRichTextBox_history.AppendText("\n");
                    this.agileRichTextBox_history.ScrollToCaret();      
                }
            }
        }
    }   
}
