using System;
using System.Collections.Generic;
using System.Text;
using ESPlus.Rapid;
using ESPlus.Serialization;
using ESFramework.Demos.DynamicGroup.Core;

namespace ESFramework.Demos.DynamicGroup.Client
{
    public class GroupTools
    {
        private RapidPassiveEngine rapidEngine;
        public GroupTools(RapidPassiveEngine _rapidEngine)
        {
            this.rapidEngine = _rapidEngine;
        }

        public void CreateGroup(string groupID)
        {
            GroupContract contract = new GroupContract(groupID);
            this.rapidEngine.CustomizeOutter.Send(GroupInformationTypes.CreateGroup, CompactPropertySerializer.Default.Serialize<GroupContract>(contract));           
        }

        public bool JoinGroup(string groupID)
        {
            GroupContract contract = new GroupContract(groupID);
            byte[] resultBytes = this.rapidEngine.CustomizeOutter.Query(GroupInformationTypes.JoinGroup, CompactPropertySerializer.Default.Serialize<GroupContract>(contract));
            if (resultBytes != null)
            {
                return BitConverter.ToBoolean(resultBytes, 0);
            }
            return false;
        }
        public void DestroyGroup(string groupID)
        {
            GroupContract contract = new GroupContract(groupID);
            this.rapidEngine.CustomizeOutter.Send(GroupInformationTypes.DestroyGroup, CompactPropertySerializer.Default.Serialize<GroupContract>(contract));  
        }

        public void QuitGroup(string groupID)
        {
            GroupContract contract = new GroupContract(groupID);
            this.rapidEngine.CustomizeOutter.Send(GroupInformationTypes.QuitGroup, CompactPropertySerializer.Default.Serialize<GroupContract>(contract));  
        }
    }
}
