﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using ESPlus.Rapid;
using ESPlus.Application.Basic;

namespace ESFramework.Demos.DynamicGroup.Client
{
    static class Program
    {
        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main()
        {
            try
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                LoginForm loginForm = new LoginForm();
                if (loginForm.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
                RapidPassiveEngine rapidPassiveEngine = new RapidPassiveEngine();
                MainForm mainForm = new MainForm();
                LogonResponse logonResponse = rapidPassiveEngine.Initialize(loginForm.UserID, "", "127.0.0.1", 4530, mainForm);
                if (logonResponse.LogonResult == LogonResult.HadLoggedOn)
                {
                    MessageBox.Show("已经在其它地方登陆！");
                    return;
                }

                GroupTools groupTools = new GroupTools(rapidPassiveEngine);
                JoinGroupForm joinGroupform = new JoinGroupForm(groupTools, loginForm.UserID);
                if (joinGroupform.ShowDialog() != DialogResult.OK)
                {
                    return;
                }
                
                
                mainForm.Initialize(loginForm.UserID, joinGroupform.CurrentGroupID, rapidPassiveEngine);

                Application.Run(mainForm);
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}