using System;
using System.Collections.Generic;
using System.Text;
using ESFramework.Engine.ContractStyle.Stream;
using ESBasic.Collections;
using System.Drawing;

namespace ESFramework.Demos.DynamicGroup.Core
{
    /// <summary>
    /// TextChatContract ̸ֽЭ顣
    /// </summary> 
    [Serializable]
    public class TextChatContract : BaseSerializeContract
    {
        #region Ctor
        public TextChatContract()
        {
        }
        public TextChatContract(string _text)
        {
            this.text = _text;
        }
        public TextChatContract(string _text, bool _containsForeignObject, SortedArray<int, uint> _ary, Font _font, Color _foreColor)
        {
            this.text = _text;
            this.containsForeignObject = _containsForeignObject;
            this.localEmotionArray = _ary;
            this.font = _font;
            this.foreColor = _foreColor;
        }
        #endregion

        #region TimeSended
        private DateTime timeSended = DateTime.Now;
        public DateTime TimeSended
        {
            get
            {
                return this.timeSended;
            }
            set
            {
                this.timeSended = value;
            }
        }
        #endregion

        #region Text
        private string text = null;
        public string Text
        {
            get
            {
                return this.text;
            }
            set
            {
                this.text = value;
            }
        }
        #endregion

        #region ContainsForeignObject
        private bool containsForeignObject = false;
        /// <summary>
        /// ContainsForeignObject ǷͼƵĸıϢ
        /// </summary>
        public bool ContainsForeignObject
        {
            get { return containsForeignObject; }
            set { containsForeignObject = value; }
        }
        #endregion

        #region LocalEmotionArray
        private SortedArray<int, uint> localEmotionArray = null; //Position - emotion Index
        public SortedArray<int, uint> LocalEmotionArray
        {
            get { return localEmotionArray; }
            set { localEmotionArray = value; }
        }
        #endregion

        #region Font
        private Font font = new Font("", 9);
        public Font Font
        {
            get { return font; }
            set { font = value; }
        }
        #endregion

        #region ForeColor
        private Color foreColor = Color.Black;
        public Color ForeColor
        {
            get { return foreColor; }
            set { foreColor = value; }
        }
        #endregion
    }
}
