<?php
/*
*  Blog  : http://www.eamonning.com
*  Email : i@eamonning.com
*  Time  : 2012-1-1 20:24:54
*/

!defined('DIARY_IN') && exit('Access Forbidden');

class Model_diary
{	
	private $tpl;
	function Model_diary()
	{
		check_guest();
		$this->tpl=new Tpl();
		$this->tpl->set_template_dir(DIARY_STYLE);
	}
	
	function onDefault()
	{
		G('page_title',lang('home'));
		send_html_header();
		$years=diary_years();
		include $this->tpl->template('index.html');
	}
	function onBrowser()
	{
		G('page_title',lang('browser'));
		send_html_header();
		$year=get('year');
		$month=get('month');
		$day=get('day');
		$years=diary_years();
		if(in_array($year,$years)){				
			$yeardetial=diary_year_detial($year);			
			$diary_view=null;
			if($day && $month && isset($yeardetial[$month]) && in_array($day.'.php',$yeardetial[$month])){
				$diary_view=diary_detial($year,$month,$day);
				if(!$diary_view){
					msg(lang('load').lang('data').lang('error'));
				}
			}
			include $this->tpl->template('diary_browser.html');				
		}else{
			msg(lang('load').lang('data').lang('error'));
		}
	}
	function onAdd()
	{		
		G('page_title',lang('add'));
		check_admin();
		send_html_header();
		include $this->tpl->template('diary_add.html');
	}
	function onSubmitadd()
	{
		check_admin();
		send_html_header();
		$datetime=post('datetime');
		$content=post('content');
		$time=strtotime($datetime);
		if($time){
			if($content){
				$status=diary_store($time,$content);
				if(true===$status){
					echo '<js>dialog.alert("'.lang('add').lang('success').'","","tourl(\'index.php?m=diary&a=browser&year='.date('Y',$time).'&month='.date('m',$time).'&day='.date('d',$time).'\')");</js>';			
				}else{
					echo '<js>dialog.alert("'.$status.'");</js>';		
				}
			}else{
				echo '<js>dialog.alert("'.lang('content_is_null').'");</js>';		
			}
		}else{
			echo '<js>dialog.alert("'.lang('datetime_is_null').'");</js>';	
		}
	}
	function onEdit()
	{
		check_admin();
		G('page_title',lang('edit'));
		send_html_header();
		$year=get('year');
		$month=get('month');
		$day=get('day');
		$diary_view=diary_detial($year,$month,$day);
		if(!$diary_view){
			msg(lang('load').lang('data').lang('error'));
		}
		$diary_view['time']=$year.'-'.$month.'-'.$day;
		include $this->tpl->template('diary_edit.html');
		
	}
	function onSubmitedit()
	{
		check_admin();
		send_html_header();
		$datetime=post('datetime');
		$content=post('content');
		$time=strtotime($datetime);
		if($time){
			if($content){
				$status=diary_store($time,$content,true);
				if(true===$status){
					echo '<js>dialog.alert("'.lang('edit').lang('success').'","","tourl(\'index.php?m=diary&a=browser&year='.date('Y',$time).'&month='.date('m',$time).'&day='.date('d',$time).'\')");</js>';			
				}else{
					echo '<js>dialog.alert("'.$status.'");</js>';		
				}
			}else{
				echo '<js>dialog.alert("'.lang('content_is_null').'");</js>';		
			}
		}else{
			echo '<js>dialog.alert("'.lang('datetime_is_null').'");</js>';	
		}
	}
	function onDelete()
	{
		check_admin();
		send_html_header();
		$year=get('year');
		$month=get('month');
		$day=get('day');
		if(true===diary_delete($year,$month,$day)){
			echo 'ok';
		}else{
			echo lang('delete').lang('failed');	
		}
	}
	
}