<?php
error_reporting(0);
session_start();
// 引入核心文件
require '../include/common.inc.php';

if ($_GET['action'] == 'login') {
	if (getOption('login_code_switch')) {
		if (strcasecmp(strtolower(trim($_POST['code'])), strtolower($_SESSION['code'])) != 0) {
			showMessage('验证码错误');
		}
	}
	$admin_id = adminLogin(trim($_POST['user']), encryptMd5($_POST['password']));
	!$admin_id && showMessage('用户名或密码不正确');
	$_SESSION['admin_id'] = $admin_id;
	if ($_POST['remember']) setcookie(session_name(), session_id(), time() + 60 * 60 * 24 * 7, '/');
	directUrl('?direction=index');
}

if (!$_SESSION['admin_id'] and $_GET['direction'] != 'login') directUrl('?direction=login');
if ($_GET['direction'] == 'logout') {
	$_SESSION['admin_id'] = null;
	session_destroy();
	showMessage('已经退出登录', '../');
}
if ($action = $_GET['action']) {
	switch ($action) {
		case 'normalset':
			$options = array();
			$options['switch'] = (int) $_POST['switch'];
			$options['close_bulletin'] = cHTML($_POST['close_bulletin']);
			$options['title'] = cHTML($_POST['title']);
			$options['header_title'] = cHTML($_POST['header_title']);
			$options['bulletin'] = cHTML($_POST['bulletin']);
			$options['css'] =  cHTML($_POST['css']);
			$options['time_zone'] = cHTML($_POST['time_zone']);
			$options['ipapi'] = cHTML($_POST['ipapi']);
			$options['login_code_switch'] = (int) ($_POST['login_code_switch']);
			$options['login_code_type'] = (int) ($_POST['login_code_type']);
			setOptions($options);
			showMessage('常规配置参数修改完毕', '?direction=normalset');
		break;
		case 'msgset':
			$options = array();
			$options['num_per_page'] = (int) $_POST['num_per_page'];
			$options['order'] = in_array($_POST['order'], array('DESC', 'ASC')) ? $_POST['order'] : 'DESC';
			$options['validation'] = (int) $_POST['validation'];
			$options['code_switch'] = (int) $_POST['code_switch'];
			$options['code_type'] = (int) $_POST['code_type'];
			$options['secret'] = (int) $_POST['secret'];
			$options['secret_word'] = trim($_POST['secret_word']);
			$options['date_format'] = $_POST['date_format'];
			$options['interval'] = (int) $_POST['interval'];
			$options['msg_password'] = $_POST['msg_password'];
			$options['msg_filter'] = cHTML($_POST['msg_filter']);
			setOptions($options);
			showMessage('留言配置参数修改完毕', '?direction=msgset');
		break;
		case 'delete':
			deleteMessages($_POST['ids']);
			showMessage("留言删除完毕", "?direction={$_GET['from']}&page={$_GET['page']}");
		break;
		case 'validation':
			validateMessages($_POST['ids']);
			showMessage("留言通过审核", "?direction={$_GET['from']}&page={$_GET['page']}");
		break;
		case 'edit':
			$id = (int) $_POST['id'];
			$_POST['nickname'] && $nickname = cHTML($_POST['nickname'], false);
			isset($nickname) && $nickname == '' && showMessage('昵称不能为空');
			$nickname && editField($id, 'nickname', $nickname);
			$_POST['message'] && $message = cHTML($_POST['message'], false);
			isset($message) && $message == '' && showMessage('留言不能为空');
			$message && editField($id, 'message', $message);
			$_POST['reply'] && editField($id, 'reply', cHTML($_POST['reply'])) && editField($id, 'replytime', time());
			$secret = $_POST['secret'] ? 1 : 0;
			editField($id, 'secret', $secret);
			$_POST['validation'] && editField($id, 'validation', '1');
			showMessage('留言编辑完毕', "?direction={$_POST['from']}&page={$_POST['page']}");
		break;
		case 'password':
			$admin = getAdmin($_SESSION['admin_id']);
			$user = trim($_POST['admin']);
			$password = encryptMd5($_POST['password']);
			if ($user == '') showMessage('请填写用户名');
			if ($_POST['newpassword'] == '') showMessage('请填写新密码');
			if ($password != $admin['password']) showMessage('原密码不正确');
			setAdmin($_SESSION['admin_id'], $user, encryptMd5($_POST['newpassword']));
			showMessage('密码修改完毕', '?direction=password');
		break;
		case 'optimize':
			optimizeTables();
			showMessage('数据库优化完毕');
		break;
		case 'phpinfo':
			phpinfo();
			exit;
		break;
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>登录到Breezee Guestbook</title>
<link href="style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="javascript.js"></script>
</head>

<body>
<?php
if ($_GET['direction'] != 'login') {
	$position = array('index' => '管理首页', 'normalset' => '常规配置', 'msgset' => '留言配置', 'message' => '管理留言', 'validation' => '审核留言', 'password' => '修改密码', 'logout' => '退出登录');
	echo "<ul id=\"nav\">\n";
	foreach ($position as $key => $value) {
		echo "<li";
		if ($_GET['direction'] == $key) echo " class=\"current_position\"";
		echo "><a href=\"?direction={$key}\" title=\"{$value}\">{$value}</a></li>\n";
	}
	echo "<li><a href=\"../\">查看留言本</a></li>\n";
	echo "</ul>\n";
	echo "<div id=\"content\">\n";
	echo "<p id=\"subnav\">{$position[$_GET['direction']]}</p>\n";
}
if ($_GET['direction'] == 'login') {
?>
<div id="login">
<form action="?action=login" method="post">
	<fieldset>
	<legend>Breezee GuestBook</legend>
	<p><label for="user">用户名：</label><input type="text" name="user" id="user" /></p>
	<p><label for="password">密码：</label><input type="password" name="password" id="password" /></p>
	<?php if (getOption('login_code_switch')) {?>
	<p><label for="code">验证码：<img src="image.php" alt="验证码" onclick="this.src='image.php?t='"+Math.random();" style="cursor: pointer" /></label><input type="text" name="code" id="code" /></p>
	<?php } ?>
	<p>Remember Me <input type="checkbox" name="remember" style="width: 20px; " /></p>
	<p><input type="submit" value="登录" /></p>
	</fieldset>
</form>
</div>
<?php
} elseif ($_GET['direction'] == 'index') {
	$options = getOptions(array('validation', 'num_per_page', 'order', 'css', 'code_switch', 'password', 'time_zone', 'date_format'));
	$n = getMsgNum('2');
	$order = array('DESC' => '降序', 'ASC' => '升序');
	$switch = array('关闭', '开启');
	$gd_info = gd_info();
?>
<div id="information">
<div>欢迎登录，这里是管理首页，下面是留言本的一些基本信息：</div>
<p>留言总数: <strong><?php echo getMsgNum('0');?></strong></p>
<p>正常显示留言数: <strong><a href="?direction=message"><?php echo getMsgNum('1');?></a></strong></p>
<p>等待审核留言数: <strong><?php echo $n && $options['validation'] ? "<a href=\"?direction=validation\">$n</a>" : 0;?></strong></p>
<p>留言审核功能: <strong><?php echo $switch[$options['validation']];?></strong></p>
<p>每页显示留言: <strong><a href="?direction=msgset"><?php echo $options['num_per_page'];?>条</a></strong></p>
<p>留言显示方式: <strong>按留言ID<?php echo $order[$options['order']];?>排列</strong></p>
<p>留言验本样式表: <strong><a href="?direction=normalset"><?php echo $options['css'];?></a></strong></p>
<p>留言验证码: <strong><?php echo $switch[$options['code_switch']];?></strong></p>
<p>生成验证码: <strong><?php echo $gd_info['GIF Create Support'] ? '支持' : '不支持(可能无法使用验证码功能)';?></strong></p>
<p>留言密码: <strong><?php echo $options['password'] == '' ? '未设置' : $options['password'];?></strong></p>
<p>时区设置: <strong><?php echo $options['time_zone'];?></strong></p>
<p>时间格式: <strong><?php echo $options['date_format'];?></strong></p>
<p>当前时间: <strong><?php echo date($options['date_format']);?></strong></p>
<p>优化数据库：<strong><a href="?action=optimize">点击优化</a></strong></p>
<p>当前留言本版本：<strong><a href="http://mai35.com" target="_blank">初始发布</a></strong></p>
<p>PHP服务器信息：<strong><a href="?action=phpinfo" target="_blank">点击查看</a></strong></p>
</div>
<?php
} elseif ($_GET['direction'] == 'normalset') {
	$options = getOptions(array('switch', 'close_bulletin', 'title', 'header_title', 'bulletin', 'css', 'time_zone', 'ipapi', 'login_code_switch', 'login_code_type'));
?>
<form action="?action=normalset" method="post">
<ul id="option">
<li>
	<label>状态</label>
	<?php
		echo getFormOption(
				array('1'=>'开放', '0'=>'关闭'),
				array('id'=>'switch', 'name'=>'switch'),
				$options['switch']);
	?>
	<p>设置留言本关闭还是开放</p>
</li>
<li><label for="close_bulletin">关闭说明</label><textarea id="close_bulletin" name="close_bulletin"><?php echo $options['close_bulletin'];?></textarea><p>留言本处于关闭状态时的说明</p></li>
<li><label for="title">标题</label><input type="text" id="title" name="title" value="<?php echo $options['title'];?>" /><p>设置留言本的标题</p></li>
<li><label for="header_title">头部标题</label><input type="text" id="header_title" name="header_title" value="<?php echo $options['header_title'];?>" /><p>留言本顶部显示的标题</p></li>
<li><label for="bulletin">公告</label><textarea id="bulletin" name="bulletin"><?php echo $options['bulletin']?></textarea><p>没有公告可保持为空</p></li>
<li>
	<label for="css">样式表</label>
	<input type="text" id="css" name="css" value="<?php echo $options['css'];?>" style="width: 140px;" />
<?php
$cssfile = array();
foreach(glob(ROOT . '/styles/*.css') as $file) {
	$css = basename($file);
	$cssfile['styles/' . $css] = $css;
}
echo getFormoption($cssfile, array('id'=>'cssoption'), $options['css']);
?>
	<a href="#" onclick="return viewCSS();" style="font-size: 12px; color: #666;">预览</a>
	<a href="#" onclick="return useCSS();" style="font-size: 12px; color: #666;">使用</a>
	<p>留言本所使用的样式表路径</p>
</li>
<li><label for="time_zone">时区</label><input type="text" id="time_zone" name="time_zone" value="<?php echo $options['time_zone'];?>" /><p>留言本使用什么时区</p></li>
<li><label for="ipapi">IP查询接口</label><input type="text" id="ipapi" name="ipapi" value="<?php echo $options['ipapi'];?>" /><p>用{ip}代替IP地址</p></li>
<li>
	<label>后台登录验证码</label>
	<?php
		echo getFormOption(
		array('1'=>'开启', '0'=>'关闭'),
		array('id'=>'login_code_switch', 'name'=>'login_code_switch'),
		$options['login_code_switch'])	
	?>
</li>
<li>
	<label>登录验证码类型</label>
	<?php
		echo getFormOption(
			array(1=>'数字型', 2=>'字母型', 3=>'混合型'),
			array('id'=>'login_code_type', 'name'=>'login_code_type'),
			$options['login_code_type']);
	?>
</li>
<li><label>&nbsp;</label><input type="submit" value="提交配置" /></li>
</ul>
</form>
<?php
} elseif ($_GET['direction'] == 'msgset') {
	$options = getOptions(array('num_per_page', 'order', 'validation', 'code_switch', 'code_type', 'date_format', 'interval', 'msg_password', 'msg_filter', 'secret', 'secret_word'));
?>
<form action="?action=msgset" method="post">
<ul id="option">
<li><label for="num_per_page">每页留言条数</label><input type="text" id="num_per_page" name="num_per_page" value="<?php echo $options['num_per_page'];?>" /><p>留言本每页显示几条留言</p></li>
<li>
	<label>留言排列方式</label>
	<?php
		echo getFormOption(
				array('DESC'=>'按时间先后从晚到早排列', 'ASC'=>'按时间先后从早到晚排列'),
				array('id'=>'order', 'name'=>'order'),
				$options['order'])
	?>
	<p>请设定留言按什么顺序排列显示</p>
</li>
<li>
	<label>留言审核</label>
	<?php
		echo getFormOption(
			array(1=>'开启', 0=>'关闭'),
			array('id'=>'validation', 'name'=>'validation'),
			$options['validation']);
	?>
	<p>开启审核后留言不会立即显示，需要管理员进行审核</p>
</li>
<li>
	<label>留言验证码</label>
	<?php
		echo getFormOption(
			array(1=>'开启', 0=>'关闭'),
			array('id'=>'code_switch', 'name'=>'code_switch'),
			$options['code_switch']);
	?>
	<p>留言时是否需要填写验证码</p>
</li>
<li>
	<label>留言验证码类型</label>
	<?php
		echo getFormOption(
			array(1=>'数字型', 2=>'字母型', 3=>'混合型'),
			array('id'=>'code_type', 'name'=>'code_type'),
			$options['code_type']);
	?>
	<p>验证码的类型</p>
</li>
<li>
	<label>悄悄话开关</label>
	<?php
		echo getFormOption(
			array(0=>'关闭', 1=>'打开'),
			array('id'=>'secret', 'name'=>'secret'),
			$options['secret']);
	?>
	<p>是否打开留言本的悄悄话功能</p>
</li>
<li>
	<label>悄悄话显示</label>
	<textarea id="secret_word" name="secret_word"><?php echo $options['secret_word'];?></textarea>
	<p>前台留言本中的悄悄话留言显示内容</p>
</li>
<li><label for="date_format">时间格式</label><input type="text" id="date_format" name="date_format" value="<?php echo $options['date_format'];?>" /><p>留言时间以什么样的格式显示 <a href="http://cn.php.net/manual/en/function.date.php" target="_blank">help</a></p></li>
<li><label for="interval">留言时间间隔</label><input type="text" id="interval" name="interval" value="<?php echo $options['interval'];?>" /><p>在指定的时间只能留言一次，没有要求填0，单位为秒</p></li>
<li><label for="msg_password">留言密码</label><input type="text" id="msg_password" name="msg_password" value="<?php echo $options['msg_password'];?>" /><p>如果设置了留言密码，只有知道该密码的人才能留言</p></li>
<li><label for="msg_filter">留言过滤</label><textarea id="msg_filter" name="msg_filter"><?php echo $options['msg_filter'];?></textarea><p>把需要过滤的词用半角都好分开，如：过滤词1,过滤词2 被过滤的词以*代替</p></li>
<li><label>&nbsp;</label><input type="submit" value="提交配置" /></li>
</ul>
</form>
<?php
} elseif ($_GET['direction'] == 'message' || $_GET['direction'] == 'validation') {
	if (!getOption('validation') && $_GET['direction'] == 'validation') showMessage('您没有开启留言审核功能，不需要审核留言', '?direction=msgset');
	require IROOT . './mpage.class.php';
	$per = getOption('num_per_page');
	$ipapi = getOption('ipapi');
	$validation = getOption('validation');
	$validation && ($_GET['direction'] != 'validation') && $validation = 1;
	$validation && ($_GET['direction'] == 'validation') && $validation = 2;
	$number = getMsgNum($validation);
	$page = new mPage($number, array('per' => $per));
	$messages = getMessages(($page->page['cur'] - 1) * $per, $per, getOption('order'), $validation);
?>
<div id="table_control">选中项：<span id="count_num">&nbsp;</span><a href="#" onclick="clickItems('all');">全选</a> <a href="#" onclick="clickItems();">取消</a> <a href="#" onclick="deleteItems();"><strong>删除</strong><?php if ($_GET['direction'] == 'validation') echo "<a href=\"#\" onclick=\"validation();\"><strong>通过审核</strong></a>";?></a> 提示：点击留言者昵称可以修改和回复留言</div>
<script type="text/javascript">
window.onload = function() {
	setTable('#EEE', '#E9F7D1');
	countNum();
}
</script>
<form id="msg_form" action="?action=delete&page=<?php echo $page->page['cur'];?>&from=<?php echo $_GET['direction'];?>" method="post">
<table id="msg_table">
<colgroup>
	<col width="25" />
	<col align="center" />
	<col width="600" />
</colgroup>
<tr class="header"><td><input type="checkbox" id="checkboxall" /></td><td>昵称</td><td>留言</td></tr>
<?php
while ($message = $sql->fetch_array($messages)) {
	$secret = '';
	if ($message['secret'] == 1) $secret = '(悄悄话)';
	echo "<tr class=\"mouse\"><td><input type=\"checkbox\" name=\"ids[]\" value=\"{$message['id']}\" /></td><td><a href=\"?direction=edit&id={$message['id']}&page={$page->page['cur']}&from={$_GET['direction']}\" title=\"回复或编辑该留言\">{$message['nickname']}</a> <br />{$secret}</td><td>{$message['message']}<p class=\"info\"><span>" . date('Y-m-d H:i:s', $message['time']) . "</span><span><a href=\"" . str_replace('{ip}', $message['ip'], $ipapi) . "\" target=\"_blank\">{$message['ip']}</a></span>";
	if ($message['reply'] != '') echo "</p><p class=\"reply\">{$message['reply']}<span>" . date('Y-m-d H:i:s', $message['replytime']) . "</span></p></td></tr>\n";
}
?>
</table>
</form>
<?php echo $page->p1();?>
<?php
} elseif ($_GET['direction'] == 'password') {
	$admin = getAdmin($_SESSION['admin_id']);
?>
<div id="table_control">&nbsp;</div>
<form action="?action=password" method="post">
<table id="msg_table">
<colgroup>
	<col width="70" align="center" />
	<col width="600" />
</colgroup>
<tr class="header"><td>字段</td><td>内容</td></tr>
<tr><td>用户名</td><td><input type="text" name="admin" value="<?php echo $admin['admin'];?>" /></tr>
<tr><td>原密码</td><td><input type="password" name="password" /></td></tr>
<tr><td>新密码</td><td><input type="password" name="newpassword" /></td></tr>
<tr><td>&nbsp;</td><td><input type="submit" value="修改密码" class="button" /></td></tr>
</table>
</form>
<?php
} elseif ($_GET['direction'] == 'edit') {
	$message = getMessage((int) $_GET['id']);
?>
<div id="table_control"><a href="#" title="返回前页" onclick="javascript: history.back();"><strong>返回</strong></a>提示：如果想要修改留言或昵称，请双击想要修改的内容。</div>
<form id="msg_form" action="?action=edit" method="post">
<table id="msg_table">
<colgroup>
	<col width="70" align="center" />
	<col width="600" />
</colgroup>
<tr class="header"><td>字段</td><td>内容</td></tr>
<tr><td>昵称</td><td><span id="rewrite_nickname" ondblclick="rewriteNickname(this);" title="双击编辑昵称"><?php echo $message['nickname'];?></span></tr>
<tr><td>留言</td><td><span id="rewrite_message" ondblclick="rewriteMessage(this);" title="双击编辑留言内容"><?php echo $message['message'];?></span></td></tr>
<tr><td>回复</td><td><textarea name="reply"><?php echo str_replace('<br />', '', $message['reply']);?></textarea></td></tr>
<tr><td>悄悄话</td><td><input type="checkbox" name="secret"<?php if ($message['secret']) echo ' checked="checked"';?> /></td></tr>
<?php
	if ($_GET['from'] == 'validation') echo "<tr><td>通过审核</td><td><input type=\"checkbox\" name=\"validation\" checked=\"checked\" /></td></tr>\n";
?>
<input type="hidden" name="id" value="<?php echo (int) $_GET['id'];?>" />
<input type="hidden" name="page" value="<?php echo (int) $_GET['page'];?>" />
<input type="hidden" name="from" value="<?php echo $_GET['from'];?>" />
<tr><td>&nbsp;</td><td><input type="submit" value="提交" class="button" /></td></tr>
</table>
</form>
<?php
}else (directUrl('?direction=index'));
if ($_GET['direction'] != 'login') {
	echo "<div id=\"footer\">\n";
	echo "Copyright © 2009 <a href=\"http://www.mai35.com/\" title=\"goto m35's homepage\">m35</a>. All Rights Reserved.\n";
	echo "</div>\n";
	echo "</div>\n";
}
?>
</body>
</html>
