function each(list, callback) {
	for (var i = 0, j = list.length; i < j; i ++) {
		callback(list[i], i);
	}
}
function $(id) {
	return document.getElementById(id);
}
function setTable(over_color, selected_color) {
	count = 0;
	var table = $('msg_table');
	var trs = table.getElementsByTagName('tr');
	for (var i=0,j=trs.length; i<j; i++) {
		if (trs[i].className == 'mouse') {
			trs[i].onmouseover = function() {this.style.backgroundColor = over_color;};
			trs[i].onmouseout = function() {this.style.backgroundColor = '';};
			trs[i].onclick = function() {this.getElementsByTagName('input')[0].click();};
			trs[i].getElementsByTagName('input')[0].onclick = function(e) {
				var tr = this.parentNode.parentNode;
				if (this.checked == true) {
					count ++;
					countNum();
					tr.style.backgroundColor = selected_color;
					tr.onmouseover = tr.onmouseout = function() {};
				} else {
					count --;
					countNum();
					tr.style.backgroundColor = '';
					tr.onmouseover = function() {this.style.backgroundColor = over_color;};
					tr.onmouseout = function() {this.style.backgroundColor = '';};
				}
				stopBubble(e);
			};
		}
	}
	$('checkboxall').onclick = function() {
		each(table.getElementsByTagName('tr'), function(o, i) {
			if (o.className == 'mouse') o.click();
		});
	}
	function setupClickEvent() {
		HTMLElement.prototype.click = function() {
			var evt = this.ownerDocument.createEvent('MouseEvents');
			evt.initMouseEvent('click', true, true, this.ownerDocument.defaultView, 1, 0, 0, 0, 0, false, false, false, false, 0, null);
			this.dispatchEvent(evt);
		}
	}
	if (typeof HTMLElement != 'undefined') setupClickEvent();
	function stopBubble(e) {
		if (e && e.stopPropagation) {
			e.stopPropagation();
		} else {
			window.event.cancelBubble = true;
		}
	}
}
function countNum() {
	$('count_num').innerHTML = count;
}
function deleteItems() {
	if (!count) return false;
	var ask = confirm(count + '条记录，确实要删除选中项吗?');
	if (ask) $('msg_form').submit();
	return false;
}
function validation() {
	if(!count) return false;
	$('msg_form').action = $('msg_form').action.replace('delete', 'validation');
	$('msg_form').submit();
	return false;
}
function clickItems(type) {
	type = type == 'all' ? false : true;
	each($('msg_table').getElementsByTagName('tr'), function(o, i) {
		if (o.className == 'mouse') if (o.getElementsByTagName('input')[0].checked == type) o.click();
	});
	return false;
}
function rewriteNickname(obj) {
	var input = "<input type='text' name='nickname' value='"+ obj.innerHTML +"' />";
	obj.innerHTML = input;
	obj.title = '';
	obj.ondblclick = null;
}
function rewriteMessage(obj) {
	var msg = obj.innerHTML.replace(/<br>/ig, "\n");
	obj.innerHTML = "<textarea name='message'>" + msg +"</textarea>";
	obj.title = '';
	obj.ondblclick = null;
}
function viewCSS() {
	window.open('../index.php?css='+$('cssoption').value);
	return false;
}
function useCSS() {
	$('css').value = $('cssoption').value;
	return false;
}